/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.jdbc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JDBCConnectionManager;
import org.apache.kylin.common.persistence.JDBCResourceStore;
import org.apache.kylin.common.persistence.JDBCSqlQueryFormat;
import org.apache.kylin.common.persistence.JDBCSqlQueryFormatProvider;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceStoreTest;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.log4j.component.helpers.MessageFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITJDBCResourceStoreTest
extends HBaseMetadataTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ITJDBCResourceStoreTest.class);
    private static final String LARGE_CELL_PATH = "/cube/_test_large_cell.json";
    private static final String Large_Content = "THIS_IS_A_LARGE_CELL";
    private KylinConfig kylinConfig;
    private JDBCConnectionManager connectionManager;
    private final String jdbcMetadataUrlNoIdentifier = "@jdbc,url=jdbc:mysql://localhost:3306/kylin_it,username=root,password=,maxActive=10,maxIdle=10";
    private final String mainIdentifier = "kylin_default_instance";
    private final String copyIdentifier = "kylin_default_instance_copy";
    private StorageURL metadataUrlBackup;
    private boolean jdbcConnectable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        KylinConfig configBackup = KylinConfig.createKylinConfig((KylinConfig)this.kylinConfig);
        Statement statement = null;
        Connection conn = null;
        this.metadataUrlBackup = this.kylinConfig.getMetadataUrl();
        this.kylinConfig.setMetadataUrl("kylin_default_instance@jdbc,url=jdbc:mysql://localhost:3306/kylin_it,username=root,password=,maxActive=10,maxIdle=10");
        JDBCSqlQueryFormat sqlQueryFormat = JDBCSqlQueryFormatProvider.createJDBCSqlQueriesFormat((String)KylinConfig.getInstanceFromEnv().getMetadataDialect());
        try {
            this.connectionManager = JDBCConnectionManager.getConnectionManager();
            conn = this.connectionManager.getConn();
            statement = conn.createStatement();
            String sql = new MessageFormat(sqlQueryFormat.getTestDropSql(), Locale.ROOT).format("kylin_default_instance", new StringBuffer(), new FieldPosition(0)).toString();
            statement.executeUpdate(sql);
            sql = new MessageFormat(sqlQueryFormat.getTestDropSql(), Locale.ROOT).format("kylin_default_instance_copy", new StringBuffer(), new FieldPosition(0)).toString();
            statement.executeUpdate(sql);
            this.jdbcConnectable = true;
            new ResourceTool().copy(configBackup, this.kylinConfig);
        }
        catch (RuntimeException ex) {
            try {
                logger.info("Init connection manager failed, skip test cases");
            }
            catch (Throwable throwable) {
                JDBCConnectionManager.closeQuietly(statement);
                JDBCConnectionManager.closeQuietly(conn);
                throw throwable;
            }
            JDBCConnectionManager.closeQuietly(statement);
            JDBCConnectionManager.closeQuietly((AutoCloseable)conn);
        }
        JDBCConnectionManager.closeQuietly((AutoCloseable)statement);
        JDBCConnectionManager.closeQuietly((AutoCloseable)conn);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
        this.kylinConfig.setMetadataUrl(this.metadataUrlBackup.toString());
    }

    @Test
    public void testConnectJDBC() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        Connection conn = null;
        try {
            conn = this.connectionManager.getConn();
            Assert.assertNotNull((Object)conn);
        }
        finally {
            JDBCConnectionManager.closeQuietly((AutoCloseable)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJdbcBasicFunction() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        Connection conn = null;
        Statement statement = null;
        String createTableSql = "CREATE TABLE test(col1 VARCHAR (10), col2 INTEGER )";
        String dropTableSql = "DROP TABLE IF EXISTS test";
        try {
            conn = this.connectionManager.getConn();
            statement = conn.createStatement();
            statement.executeUpdate(dropTableSql);
            statement.executeUpdate(createTableSql);
            statement.executeUpdate(dropTableSql);
        }
        catch (Throwable throwable) {
            JDBCConnectionManager.closeQuietly(statement);
            JDBCConnectionManager.closeQuietly((AutoCloseable)conn);
            throw throwable;
        }
        JDBCConnectionManager.closeQuietly((AutoCloseable)statement);
        JDBCConnectionManager.closeQuietly((AutoCloseable)conn);
    }

    @Test
    public void testMsgFormatter() {
        System.out.println(MessageFormatter.format((String)"{}:{}", (Object)"a", (Object)"b"));
    }

    @Test
    public void testResourceStoreBasic() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        ResourceStoreTest.testAStore((String)ResourceStoreTest.mockUrl((String)StringUtils.substringAfterLast((String)"kylin_default_instance@jdbc,url=jdbc:mysql://localhost:3306/kylin_it,username=root,password=,maxActive=10,maxIdle=10", (String)"@"), (KylinConfig)this.kylinConfig), (KylinConfig)this.kylinConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJDBCStoreWithLargeCell() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        JDBCResourceStore store = null;
        StringEntity content = new StringEntity(Large_Content);
        String largePath = "/large/large.json";
        try {
            String oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)ResourceStoreTest.mockUrl((String)"jdbc", (KylinConfig)this.kylinConfig));
            store = new JDBCResourceStore(KylinConfig.getInstanceFromEnv());
            store.deleteResource(largePath);
            store.checkAndPutResource(largePath, (RootPersistentEntity)content, StringEntity.serializer);
            TestCase.assertTrue((boolean)store.exists(largePath));
            StringEntity t = (StringEntity)store.getResource(largePath, StringEntity.serializer);
            Assert.assertEquals((Object)content, (Object)t);
            store.deleteResource(LARGE_CELL_PATH);
            ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
        }
        finally {
            if (store != null) {
                store.deleteResource(LARGE_CELL_PATH);
            }
        }
    }

    @Test
    public void testPerformance() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        ResourceStoreTest.testPerformance((String)ResourceStoreTest.mockUrl((String)"jdbc", (KylinConfig)this.kylinConfig), (KylinConfig)this.kylinConfig);
        ResourceStoreTest.testPerformance((String)ResourceStoreTest.mockUrl((String)"hbase", (KylinConfig)this.kylinConfig), (KylinConfig)this.kylinConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxCell() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        byte[] data = new byte[512000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 0;
        }
        JDBCResourceStore store = null;
        ByteEntity content = new ByteEntity(data);
        try {
            String oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)ResourceStoreTest.mockUrl((String)"jdbc", (KylinConfig)this.kylinConfig));
            store = new JDBCResourceStore(KylinConfig.getInstanceFromEnv());
            store.deleteResource(LARGE_CELL_PATH);
            store.checkAndPutResource(LARGE_CELL_PATH, (RootPersistentEntity)content, ByteEntity.serializer);
            TestCase.assertTrue((boolean)store.exists(LARGE_CELL_PATH));
            ByteEntity t = (ByteEntity)store.getResource(LARGE_CELL_PATH, ByteEntity.serializer);
            Assert.assertEquals((Object)((Object)content), (Object)((Object)t));
            store.deleteResource(LARGE_CELL_PATH);
            ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
        }
        finally {
            if (store != null) {
                store.deleteResource(LARGE_CELL_PATH);
            }
        }
    }

    @Test
    public void testPerformanceWithResourceTool() throws Exception {
        Assume.assumeTrue((boolean)this.jdbcConnectable);
        KylinConfig tmpConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        tmpConfig.setMetadataUrl("kylin_default_instance_copy@jdbc,url=jdbc:mysql://localhost:3306/kylin_it,username=root,password=,maxActive=10,maxIdle=10");
        JDBCResourceStore store = (JDBCResourceStore)ResourceStore.getStore((KylinConfig)this.kylinConfig);
        NavigableSet executes = store.listResources("/execute");
        NavigableSet executeOutputs = store.listResources("/execute_output");
        long startTs = System.currentTimeMillis();
        for (String execute : executes) {
            String uuid = StringUtils.substringAfterLast((String)execute, (String)"/");
            RawResource executeResource = store.getResource(execute);
            HashMap<String, RawResource> executeOutputResourceMap = new HashMap<String, RawResource>();
            for (String executeOutput : executeOutputs) {
                if (!executeOutput.contains(uuid)) continue;
                RawResource executeOutputResource = store.getResource(executeOutput);
                executeOutputResourceMap.put(executeOutput, executeOutputResource);
            }
            for (int i = 0; i < 200; ++i) {
                String newUuid = UUID.randomUUID().toString();
                store.putResource("/execute/" + newUuid, executeResource.content(), System.currentTimeMillis());
                for (String key : executeOutputResourceMap.keySet()) {
                    String step = StringUtils.substringAfterLast((String)key, (String)uuid);
                    store.putResource("/execute_output/" + newUuid + step, ((RawResource)executeOutputResourceMap.get(key)).content(), System.currentTimeMillis());
                }
            }
        }
        long queryNumBeforeCopy = store.getQueriedSqlNum();
        new ResourceTool().copy(this.kylinConfig, tmpConfig);
        long endTs = System.currentTimeMillis();
        long queryNumAfterCopy = store.getQueriedSqlNum();
        JDBCResourceStore resourceStoreCopy = (JDBCResourceStore)ResourceStore.getStore((KylinConfig)tmpConfig);
        int executeNum = store.listResources("/execute").size();
        int executeOutputNum = store.listResources("/execute_output").size();
        Assert.assertEquals((long)executeNum, (long)resourceStoreCopy.listResources("/execute").size());
        Assert.assertEquals((long)executeOutputNum, (long)resourceStoreCopy.listResources("/execute_output").size());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
        String startTime = sdf.format(new Date(Long.parseLong(String.valueOf(startTs))));
        String endTime = sdf.format(new Date(Long.parseLong(String.valueOf(endTs))));
        logger.info("Test performance with ResourceTool done during " + startTime + " to " + endTime);
        logger.info("Now there is " + executeNum + " execute data and " + executeOutputNum + " execute_output data in resource store.");
        logger.info("Resource store run " + queryNumBeforeCopy + " sqls for metadata generation, and " + (queryNumAfterCopy - queryNumBeforeCopy) + " sqls for copy with ResourceTool.");
        TestCase.assertTrue((queryNumAfterCopy - queryNumBeforeCopy < queryNumBeforeCopy ? 1 : 0) != 0);
        logger.info("This test is expected to be done in 10 mins.");
        TestCase.assertTrue((endTs - startTs < 600000L ? 1 : 0) != 0);
    }

    public static class ByteEntity
    extends RootPersistentEntity {
        public static final Serializer<ByteEntity> serializer = new Serializer<ByteEntity>(){

            public void serialize(ByteEntity obj, DataOutputStream out) throws IOException {
                byte[] data = obj.getData();
                out.writeInt(data.length);
                out.write(data);
            }

            public ByteEntity deserialize(DataInputStream in) throws IOException {
                int length = in.readInt();
                byte[] bytes = new byte[length];
                in.read(bytes);
                return new ByteEntity(bytes);
            }
        };
        byte[] data;

        public ByteEntity() {
        }

        public ByteEntity(byte[] data) {
            this.data = data;
        }

        public static Serializer<ByteEntity> getSerializer() {
            return serializer;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }
    }
}

