/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.StorageFactory;
import org.apache.kylin.storage.StorageMockUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITStorageTest
extends HBaseMetadataTestCase {
    private IStorageQuery storageEngine;
    private CubeInstance cube;
    private StorageContext context;
    private StorageMockUtils mockup;

    @BeforeClass
    public static void setupResource() throws Exception {
    }

    @AfterClass
    public static void tearDownResource() {
    }

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)ITStorageTest.getTestConfig());
        this.cube = cubeMgr.getCube("test_kylin_cube_without_slr_left_join_empty");
        Assert.assertNotNull((Object)this.cube);
        this.storageEngine = StorageFactory.createQuery((IRealization)this.cube);
        this.context = new StorageContext();
        this.context.setConnUrl(KylinConfig.getInstanceFromEnv().getStorageUrl());
        this.mockup = new StorageMockUtils(this.cube.getModel());
    }

    @After
    public void tearDown() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void test01() {
        CompareTupleFilter filter;
        List aggregations;
        List groups = this.mockup.buildGroups();
        int count = this.search(groups, aggregations = this.mockup.buildAggregations(), (TupleFilter)(filter = this.mockup.buildFilter1((TblColRef)groups.get(0))), this.context);
        Assert.assertTrue((count >= 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int search(List<TblColRef> groups, List<FunctionDesc> aggregations, TupleFilter filter, StorageContext context) {
        int count = 0;
        try (ITupleIterator iterator = null;){
            SQLDigest sqlDigest = new SQLDigest("default.test_kylin_fact", Collections.emptySet(), null, groups, (Set)Sets.newHashSet(), Collections.emptyMap(), false, Collections.emptySet(), aggregations, Collections.emptyList(), Collections.emptyList(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), filter, null, new ArrayList(), new ArrayList(), false, false, new HashSet());
            iterator = this.storageEngine.search(context, sqlDigest, this.mockup.newTupleInfo(groups, aggregations));
            while (iterator.hasNext()) {
                ITuple tuple = (ITuple)iterator.next();
                System.out.println("Tuple = " + tuple);
                ++count;
            }
        }
        return count;
    }
}

