/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.HadoopUtil;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ITHdfsOpsTest
extends HBaseMetadataTestCase {
    FileSystem fileSystem;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.fileSystem = HadoopUtil.getWorkingFileSystem();
    }

    @Test
    public void TestPath() throws IOException {
        String hdfsWorkingDirectory = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        Path coprocessorDir = new Path(hdfsWorkingDirectory, "test");
        this.fileSystem.mkdirs(coprocessorDir);
        Path newFile = new Path(coprocessorDir, "test_file");
        newFile = newFile.makeQualified(this.fileSystem.getUri(), null);
        FSDataOutputStream stream = this.fileSystem.create(newFile);
        stream.write(new byte[]{0, 1, 2});
        stream.close();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }
}

