/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStoreTest;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.storage.hbase.HBaseResourceStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ITHBaseResourceStoreTest
extends HBaseMetadataTestCase {
    private KylinConfig kylinConfig;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testHBaseStore() throws Exception {
        String storeName = "org.apache.kylin.storage.hbase.HBaseResourceStore";
        ResourceStoreTest.testAStore((String)ResourceStoreTest.mockUrl((String)"hbase", (KylinConfig)this.kylinConfig), (KylinConfig)this.kylinConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBaseStoreWithLargeCell() throws Exception {
        String path = "/cube/_test_large_cell.json";
        String largeContent = "THIS_IS_A_LARGE_CELL";
        StringEntity content = new StringEntity(largeContent);
        String oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)ResourceStoreTest.mockUrl((String)"hbase", (KylinConfig)this.kylinConfig));
        HBaseResourceStore store = new HBaseResourceStore(KylinConfig.getInstanceFromEnv());
        Configuration hconf = store.getConnection().getConfiguration();
        int origSize = Integer.parseInt(hconf.get("hbase.client.keyvalue.maxsize", "10485760"));
        try {
            hconf.set("hbase.client.keyvalue.maxsize", String.valueOf(largeContent.length() - 1));
            store.deleteResource(path);
            store.checkAndPutResource(path, (RootPersistentEntity)content, StringEntity.serializer);
            Assert.assertTrue((boolean)store.exists(path));
            StringEntity t = (StringEntity)store.getResource(path, StringEntity.serializer);
            Assert.assertEquals((Object)content, (Object)t);
            Path redirectPath = store.bigCellHDFSPath(path);
            FileSystem fileSystem = FileSystem.get((Configuration)hconf);
            Assert.assertTrue((boolean)fileSystem.exists(redirectPath));
            FSDataInputStream in = fileSystem.open(redirectPath);
            Assert.assertEquals((Object)largeContent, (Object)in.readUTF());
            in.close();
            store.deleteResource(path);
            ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
        }
        finally {
            hconf.set("hbase.client.keyvalue.maxsize", "" + origSize);
            store.deleteResource(path);
        }
    }
}

