/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceStoreTest;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.service.AclTableMigrationTool;
import org.apache.kylin.rest.util.Serializer;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.HBaseResourceStore;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ITAclTableMigrationToolTest
extends HBaseMetadataTestCase {
    private KylinConfig kylinConfig;
    private String STORE_WITH_OLD_TABLE = "STORE_WITH_OLD_TABLE";
    private String STORE_WITHOUT_OLD_TABLE = "STORE_WITHOUT_OLD_TABLE";
    private Logger logger = LoggerFactory.getLogger(ITAclTableMigrationToolTest.class);
    private TableName aclTable = TableName.valueOf((String)(this.STORE_WITH_OLD_TABLE + "_acl"));
    private TableName userTable = TableName.valueOf((String)(this.STORE_WITH_OLD_TABLE + "_user"));
    private Serializer<SimpleGrantedAuthority[]> ugaSerializer = new Serializer(SimpleGrantedAuthority[].class);
    private AclTableMigrationTool aclTableMigrationJob;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!(ResourceStore.getStore((KylinConfig)this.kylinConfig) instanceof HBaseResourceStore)) {
            this.logger.info("HBase Enviroment not found. Ignore this test");
            return;
        }
        this.cleanUpAll();
        this.createTestHTables();
        this.addRecordsToTable();
        this.aclTableMigrationJob = new AclTableMigrationTool();
    }

    @Test
    public void testBasic() throws Exception {
        String oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)(this.STORE_WITHOUT_OLD_TABLE + "@hbase"));
        boolean check = this.aclTableMigrationJob.checkIfNeedMigrate(this.kylinConfig);
        TestCase.assertFalse((boolean)check);
        ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
        oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)(this.STORE_WITH_OLD_TABLE + "@hbase"));
        check = this.aclTableMigrationJob.checkIfNeedMigrate(this.kylinConfig);
        TestCase.assertTrue((boolean)check);
        ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
        oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)(this.STORE_WITH_OLD_TABLE + "@hbase"));
        this.aclTableMigrationJob.migrate(this.kylinConfig);
        check = this.aclTableMigrationJob.checkIfNeedMigrate(this.kylinConfig);
        TestCase.assertFalse((boolean)check);
        ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
    }

    @After
    public void after() throws Exception {
        this.cleanUpAll();
        this.cleanupTestMetadata();
    }

    private void cleanUpAll() throws IOException {
        this.cleanUpMetastoreData(this.STORE_WITH_OLD_TABLE);
        this.cleanUpMetastoreData(this.STORE_WITHOUT_OLD_TABLE);
        this.dropTestHTables();
    }

    private void createTestHTables() throws IOException {
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        this.creatTable((Admin)hbaseAdmin, conf, this.aclTable, new String[]{"i", "a"});
        this.creatTable((Admin)hbaseAdmin, conf, this.userTable, new String[]{"a"});
        hbaseAdmin.close();
    }

    private void addRecordsToTable() throws Exception {
        Table htable = HBaseConnection.get((StorageURL)this.kylinConfig.getStorageUrl()).getTable(this.userTable);
        Pair<byte[], byte[]> pair = this.getRandomUserRecord();
        Put put = new Put((byte[])pair.getFirst());
        put.addColumn(Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c"), (byte[])pair.getSecond());
        htable.put(put);
    }

    private void cleanUpMetastoreData(String storeName) throws IOException {
        String oldUrl = ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)(this.STORE_WITH_OLD_TABLE + "@hbase"));
        ResourceStore store = ResourceStore.getStore((KylinConfig)this.kylinConfig);
        NavigableSet allRes1 = store.listResources("/user/");
        NavigableSet allRes2 = store.listResources("/acl/");
        if (allRes1 != null) {
            for (String res : allRes1) {
                store.deleteResource(res);
            }
        }
        if (allRes2 != null) {
            for (String res : allRes2) {
                store.deleteResource(res);
            }
        }
        ResourceStoreTest.replaceMetadataUrl((KylinConfig)this.kylinConfig, (String)oldUrl);
    }

    private void dropTestHTables() throws IOException {
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        if (hbaseAdmin.tableExists(this.aclTable)) {
            if (hbaseAdmin.isTableEnabled(this.aclTable)) {
                hbaseAdmin.disableTable(this.aclTable);
            }
            hbaseAdmin.deleteTable(this.aclTable);
        }
        if (hbaseAdmin.tableExists(this.userTable)) {
            if (hbaseAdmin.isTableEnabled(this.userTable)) {
                hbaseAdmin.disableTable(this.userTable);
            }
            hbaseAdmin.deleteTable(this.userTable);
        }
        hbaseAdmin.close();
    }

    private void creatTable(Admin admin, Configuration conf, TableName tableName, String[] family) throws IOException {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        for (int i = 0; i < family.length; ++i) {
            desc.addFamily(new HColumnDescriptor(family[i]));
        }
        if (admin.tableExists(tableName)) {
            throw new IOException("Table : " + tableName + " exists");
        }
        admin.createTable(desc);
        this.logger.info("create table Success!");
    }

    private Pair<byte[], byte[]> getRandomUserRecord() throws JsonProcessingException {
        byte[] key = Bytes.toBytes((String)"username");
        List<Object> authorities = new ArrayList();
        if (authorities == null) {
            authorities = Collections.emptyList();
        }
        SimpleGrantedAuthority[] serializing = new SimpleGrantedAuthority[authorities.size() + 1];
        serializing[0] = new SimpleGrantedAuthority("PWD:password");
        int i = 1;
        for (GrantedAuthority grantedAuthority : authorities) {
            serializing[i++] = new SimpleGrantedAuthority(grantedAuthority.getAuthority());
        }
        byte[] value = this.ugaSerializer.serialize((Object)serializing);
        return Pair.newPair((Object)key, (Object)value);
    }
}

