/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.query.H2Database;
import org.apache.kylin.source.datagen.ModelDataGenerator;
import org.apache.kylin.source.jdbc.JdbcTableReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITJdbcTableReaderTest
extends LocalFileMetadataTestCase
implements ISourceAware {
    protected KylinConfig config = null;
    protected static Connection h2Connection = null;

    @Before
    public void setup() throws Exception {
        super.createTestMetadata(new String[0]);
        System.setProperty("kylin.source.jdbc.connection-url", "jdbc:h2:mem:db_jdbc_table_reader");
        System.setProperty("kylin.source.jdbc.driver", "org.h2.Driver");
        System.setProperty("kylin.source.jdbc.user", "sa");
        System.setProperty("kylin.source.jdbc.pass", "");
        this.config = KylinConfig.getInstanceFromEnv();
        h2Connection = DriverManager.getConnection("jdbc:h2:mem:db_jdbc_table_reader", "sa", "");
        String project = "default";
        H2Database h2DB = new H2Database(h2Connection, this.config, project);
        DataModelManager mgr = DataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ModelDataGenerator gen = new ModelDataGenerator(mgr.getDataModelDesc("ci_left_join_model"), 10000);
        gen.generate();
        h2DB.loadAllTables();
    }

    @After
    public void after() throws Exception {
        super.cleanupTestMetadata();
        if (h2Connection != null) {
            try {
                h2Connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        System.clearProperty("kylin.source.jdbc.connection-url");
        System.clearProperty("kylin.source.jdbc.driver");
        System.clearProperty("kylin.source.jdbc.user");
        System.clearProperty("kylin.source.jdbc.pass");
    }

    @Test
    public void test() throws Exception {
        JdbcTableReader reader = new JdbcTableReader("default", "test_kylin_fact");
        int rowNumber = 0;
        while (reader.next()) {
            String[] row = reader.getRow();
            Assert.assertEquals((long)11L, (long)row.length);
            ++rowNumber;
        }
        reader.close();
        Assert.assertEquals((long)10000L, (long)rowNumber);
    }

    public int getSourceType() {
        return 8;
    }

    public KylinConfig getConfig() {
        return ITJdbcTableReaderTest.getTestConfig();
    }
}

