/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.H2Database;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceManager;
import org.apache.kylin.source.datagen.ModelDataGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITJdbcSourceTableLoaderTest
extends LocalFileMetadataTestCase
implements ISourceAware {
    protected KylinConfig config = null;
    protected static Connection h2Connection = null;

    @Before
    public void setup() throws Exception {
        super.createTestMetadata(new String[0]);
        System.setProperty("kylin.source.jdbc.connection-url", "jdbc:h2:mem:db_jdbc_source_table_loader");
        System.setProperty("kylin.source.jdbc.driver", "org.h2.Driver");
        System.setProperty("kylin.source.jdbc.user", "sa");
        System.setProperty("kylin.source.jdbc.pass", "");
        this.config = KylinConfig.getInstanceFromEnv();
        h2Connection = DriverManager.getConnection("jdbc:h2:mem:db_jdbc_source_table_loader", "sa", "");
        String project = "default";
        H2Database h2DB = new H2Database(h2Connection, this.config, project);
        DataModelManager mgr = DataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ModelDataGenerator gen = new ModelDataGenerator(mgr.getDataModelDesc("ci_left_join_model"), 10000);
        gen.generate();
        h2DB.loadAllTables();
    }

    @After
    public void after() throws Exception {
        super.cleanupTestMetadata();
        if (h2Connection != null) {
            try {
                h2Connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        System.clearProperty("kylin.source.jdbc.connection-url");
        System.clearProperty("kylin.source.jdbc.driver");
        System.clearProperty("kylin.source.jdbc.user");
        System.clearProperty("kylin.source.jdbc.pass");
    }

    @Test
    public void test() throws Exception {
        ISource source = SourceManager.getSource((ISourceAware)this);
        ISourceMetadataExplorer explr = source.getSourceMetadataExplorer();
        Pair pair = explr.loadTableMetadata("DEFAULT", "TEST_KYLIN_FACT", "default");
        Assert.assertTrue((boolean)((TableDesc)pair.getFirst()).getIdentity().equals("DEFAULT.TEST_KYLIN_FACT"));
        pair = explr.loadTableMetadata("EDW", "TEST_CAL_DT", "default");
        Assert.assertTrue((boolean)((TableDesc)pair.getFirst()).getIdentity().equals("EDW.TEST_CAL_DT"));
    }

    public int getSourceType() {
        return 8;
    }

    public KylinConfig getConfig() {
        return this.config;
    }
}

