/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.SourceManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITSnapshotManagerTest
extends HBaseMetadataTestCase {
    SnapshotManager snapshotMgr;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.snapshotMgr = SnapshotManager.getInstance((KylinConfig)ITSnapshotManagerTest.getTestConfig());
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void basicTest() throws Exception {
        String tableName = "EDW.TEST_SITES";
        TableDesc tableDesc = TableMetadataManager.getInstance((KylinConfig)ITSnapshotManagerTest.getTestConfig()).getTableDesc(tableName, "default");
        IReadableTable hiveTable = SourceManager.createReadableTable((TableDesc)tableDesc, null);
        String snapshotPath = this.snapshotMgr.buildSnapshot(hiveTable, tableDesc, ITSnapshotManagerTest.getTestConfig()).getResourcePath();
        this.snapshotMgr.wipeoutCache();
        SnapshotTable snapshot = this.snapshotMgr.getSnapshotTable(snapshotPath);
        IReadableTable.TableReader hiveReader = hiveTable.getReader();
        IReadableTable.TableReader snapshotReader = snapshot.getReader();
        while (true) {
            boolean hiveNext = hiveReader.next();
            boolean snapshotNext = snapshotReader.next();
            Assert.assertEquals((Object)hiveNext, (Object)snapshotNext);
            if (!hiveNext) break;
            Object[] hiveRow = hiveReader.getRow();
            Object[] snapshotRow = snapshotReader.getRow();
            Assert.assertArrayEquals((Object[])hiveRow, (Object[])snapshotRow);
        }
    }
}

