/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.restclient;

import java.io.File;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITRestClientTest
extends HBaseMetadataTestCase {
    private static Server server = null;
    private static SystemPropertiesOverride sysPropsOverride = new SystemPropertiesOverride();
    private static final String HOST = "localhost";
    private static final int PORT = new Random().nextInt(100) + 37070;
    private static final String USERNAME = "ADMIN";
    private static final String PASSWD = "KYLIN";
    private static final String PROJECT_NAME = "default";
    private static final String CUBE_NAME = "ci_left_join_cube";
    private static final Logger logger = LoggerFactory.getLogger(ITRestClientTest.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        logger.info("random jetty port: " + PORT);
        sysPropsOverride.override("spring.profiles.active", "testing");
        sysPropsOverride.override("catalina.home", ".");
        ITRestClientTest.staticCreateTestMetadata();
        ITRestClientTest.startJetty();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ITRestClientTest.stopJetty();
        ITRestClientTest.staticCleanupTestMetadata();
        sysPropsOverride.restore();
    }

    @Test
    public void testGetCube() throws Exception {
        RestClient client = new RestClient(HOST, PORT, USERNAME, PASSWD);
        HashMap result = client.getCube(CUBE_NAME);
        Assert.assertEquals((Object)"READY", result.get("status"));
    }

    @Test
    public void testChangeCubeStatus() throws Exception {
        RestClient client = new RestClient(HOST, PORT, USERNAME, PASSWD);
        Assert.assertTrue((boolean)client.disableCube(CUBE_NAME));
        Assert.assertTrue((boolean)client.enableCube(CUBE_NAME));
    }

    @Test
    public void testChangeCache() throws Exception {
        RestClient client = new RestClient(HOST, PORT, USERNAME, PASSWD);
        Assert.assertTrue((boolean)client.disableCache());
        Assert.assertTrue((boolean)client.enableCache());
    }

    @Test
    public void testQuery() throws Exception {
        RestClient client = new RestClient(HOST, PORT, USERNAME, PASSWD);
        String sql = "select count(*) from TEST_KYLIN_FACT; ";
        HttpResponse result = client.query(sql, PROJECT_NAME);
    }

    protected static void stopJetty() throws Exception {
        File workFolder;
        if (server != null) {
            server.stop();
        }
        if ((workFolder = new File("work")).isDirectory() && workFolder.exists()) {
            FileUtils.deleteDirectory((File)workFolder);
        }
    }

    protected static void startJetty() throws Exception {
        server = new Server(PORT);
        WebAppContext context = new WebAppContext();
        context.setDescriptor("../server/src/main/webapp/WEB-INF/web.xml");
        context.setResourceBase("../server/src/main/webapp");
        context.setContextPath("/kylin");
        context.setParentLoaderPriority(true);
        server.setHandler((Handler)context);
        server.start();
    }

    private static class SystemPropertiesOverride {
        HashMap<String, String> backup = new HashMap();

        private SystemPropertiesOverride() {
        }

        public void override(String key, String value) {
            this.backup.put(key, System.getProperty(key));
            System.setProperty(key, value);
        }

        public void restore() {
            for (String key : this.backup.keySet()) {
                String value = this.backup.get(key);
                if (value == null) {
                    System.clearProperty(key);
                    continue;
                }
                System.setProperty(key, value);
            }
            this.backup.clear();
        }
    }
}

