/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.LogManager;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.query.H2Database;
import org.apache.kylin.query.HackedDbUnitAssert;
import org.apache.kylin.query.ICompareQueryTranslator;
import org.apache.kylin.query.QueryConnection;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.routing.rules.RemoveBlackoutRealizationsRule;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.parquet.Strings;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.h2.H2Connection;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinTestBase {
    private static final Logger logger;
    public static boolean PRINT_RESULT;
    protected static final String resultTableName = "query result of ";
    protected static KylinConfig config;
    protected static Connection cubeConnection;
    protected static Connection h2Connection;
    protected static String joinType;
    protected static int h2InstanceCount;
    protected static int compQueryCount;
    protected static ArrayList<String> zeroResultQueries;
    protected static String ITDirHeader;

    protected static void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    protected static List<File> getFilesFromFolder(File folder, String fileType) {
        System.out.println(folder.getAbsolutePath());
        TreeSet<File> set = new TreeSet<File>(new FileByNameComparator());
        for (File fileEntry : folder.listFiles()) {
            if (!fileEntry.getName().toLowerCase(Locale.ROOT).endsWith(fileType.toLowerCase(Locale.ROOT))) continue;
            set.add(fileEntry);
        }
        return new ArrayList<File>(set);
    }

    public static String getTextFromFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }

    protected static List<String> getParameterFromFile(File sqlFile) throws IOException {
        String sqlFileName = sqlFile.getAbsolutePath();
        int prefixIndex = sqlFileName.lastIndexOf(".sql");
        String dataFielName = sqlFileName.substring(0, prefixIndex) + ".dat";
        File dataFile = new File(dataFielName);
        List parameters = Files.readLines((File)dataFile, (Charset)Charset.defaultCharset());
        return parameters;
    }

    protected static void printResult(ITable resultTable) throws DataSetException {
        int i;
        StringBuilder sb = new StringBuilder();
        int columnCount = resultTable.getTableMetaData().getColumns().length;
        String[] columns = new String[columnCount];
        for (i = 0; i < columnCount; ++i) {
            sb.append(resultTable.getTableMetaData().getColumns()[i].getColumnName());
            sb.append("-");
            sb.append(resultTable.getTableMetaData().getColumns()[i].getDataType());
            sb.append("\t");
            columns[i] = resultTable.getTableMetaData().getColumns()[i].getColumnName();
        }
        sb.append("\n");
        for (i = 0; i < resultTable.getRowCount(); ++i) {
            for (int j = 0; j < columns.length; ++j) {
                sb.append(resultTable.getValue(i, columns[j]));
                sb.append("\t");
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
    }

    protected Set<String> buildExclusiveSet(String[] exclusiveQuerys) {
        HashSet<String> exclusiveSet = new HashSet<String>();
        if (exclusiveQuerys != null) {
            for (String query : exclusiveQuerys) {
                exclusiveSet.add(query);
            }
        }
        return exclusiveSet;
    }

    protected ITable executeQuery(IDatabaseConnection dbConn, String queryName, String sql, boolean needSort) throws Exception {
        QueryContextFacade.resetCurrent();
        sql = KylinTestBase.changeJoinType(sql, joinType);
        ITable queryTable = dbConn.createQueryTable(resultTableName + queryName, sql);
        if (needSort) {
            String[] columnNames = new String[queryTable.getTableMetaData().getColumns().length];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = queryTable.getTableMetaData().getColumns()[i].getColumnName();
            }
            queryTable = new SortedTable(queryTable, columnNames);
        }
        if (PRINT_RESULT) {
            KylinTestBase.printResult(queryTable);
        }
        return queryTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeQuery(String sql, boolean needDisplay) throws Exception {
        QueryContextFacade.resetCurrent();
        sql = KylinTestBase.changeJoinType(sql, joinType);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            logger.info("start running...");
            statement = cubeConnection.createStatement();
            resultSet = statement.executeQuery(sql);
            logger.info("stop running...");
            int n = this.output(resultSet, needDisplay);
            return n;
        }
        catch (SQLException sqlException) {
            Pair result = PushDownUtil.tryPushDownSelectQuery((String)"default", (String)sql, (String)"DEFAULT", (SQLException)sqlException, (boolean)BackdoorToggles.getPrepareOnly());
            if (result == null) {
                throw sqlException;
            }
            int n = ((List)result.getFirst()).size();
            return n;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownSelectQuery(String sql) throws Exception {
        SQLException mockException = new SQLException("", (Throwable)new NoRealizationFoundException(""));
        return PushDownUtil.tryPushDownSelectQuery((String)"default", (String)sql, (String)"DEFAULT", (SQLException)mockException, (boolean)BackdoorToggles.getPrepareOnly());
    }

    protected Pair<List<List<String>>, List<SelectedColumnMeta>> tryPushDownNonSelectQuery(String sql, boolean isPrepare) throws Exception {
        return PushDownUtil.tryPushDownNonSelectQuery((String)"default", (String)sql, (String)"DEFAULT", (boolean)isPrepare);
    }

    protected ITable executeDynamicQuery(IDatabaseConnection dbConn, String queryName, String sql, List<String> parameters, boolean needSort) throws Exception {
        QueryContextFacade.resetCurrent();
        sql = KylinTestBase.changeJoinType(sql, joinType);
        PreparedStatement prepStat = dbConn.getConnection().prepareStatement(sql);
        for (int j = 1; j <= parameters.size(); ++j) {
            prepStat.setString(j, parameters.get(j - 1).trim());
        }
        ITable queryTable = dbConn.createTable(resultTableName + queryName, prepStat);
        String[] columnNames = new String[queryTable.getTableMetaData().getColumns().length];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = queryTable.getTableMetaData().getColumns()[i].getColumnName();
        }
        if (needSort) {
            queryTable = new SortedTable(queryTable, columnNames);
        }
        if (PRINT_RESULT) {
            KylinTestBase.printResult(queryTable);
        }
        return queryTable;
    }

    protected static String changeJoinType(String sql, String targetType) {
        if (targetType.equalsIgnoreCase("default")) {
            return sql;
        }
        String specialStr = "changeJoinType_DELIMITERS";
        sql = sql.replaceAll(System.getProperty("line.separator"), " " + specialStr + " ");
        Object[] tokens = StringUtils.split((String)sql, null);
        for (int i = 0; i < tokens.length - 1; ++i) {
            if (!tokens[i].equalsIgnoreCase("inner") && !((String)tokens[i]).equalsIgnoreCase("left") || !((String)tokens[i + 1]).equalsIgnoreCase("join")) continue;
            tokens[i] = targetType.toLowerCase(Locale.ROOT);
        }
        String ret = StringUtils.join((Object[])tokens, (String)" ");
        ret = ret.replaceAll(specialStr, System.getProperty("line.separator"));
        logger.info("The actual sql executed is: " + ret);
        return ret;
    }

    protected void execQueryUsingH2(String queryFolder, boolean needSort) throws Exception {
        logger.info("---------- Running H2 queries: " + queryFolder);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            logger.info("Query Result from H2 - " + queryName);
            this.executeQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql, needSort);
        }
    }

    protected void verifyResultRowColCount(String queryFolder) throws Exception {
        logger.info("---------- verify result count in folder: " + queryFolder);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            File expectResultFile = new File(sqlFile.getParent(), sqlFile.getName() + ".expected");
            Pair<Integer, Integer> pair = this.getExpectedRowAndCol(expectResultFile);
            int expectRowCount = (Integer)pair.getFirst();
            int expectColCount = (Integer)pair.getSecond();
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, false);
            if (BackdoorToggles.getPrepareOnly()) {
                Assert.assertEquals((String)queryName, (long)0L, (long)kylinTable.getRowCount());
            } else if (expectRowCount >= 0) {
                Assert.assertEquals((String)queryName, (long)expectRowCount, (long)kylinTable.getRowCount());
            }
            if (expectColCount < 0) continue;
            Assert.assertEquals((String)queryName, (long)expectColCount, (long)kylinTable.getTableMetaData().getColumns().length);
        }
    }

    private Pair<Integer, Integer> getExpectedRowAndCol(File expectResultFile) throws IOException {
        List lines = Files.readLines((File)expectResultFile, (Charset)Charset.forName("UTF-8"));
        int row = -1;
        int col = -1;
        try {
            row = Integer.parseInt(((String)lines.get(0)).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            col = Integer.parseInt(((String)lines.get(1)).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Pair.newPair((Object)row, (Object)col);
    }

    protected void verifyResultContent(String queryFolder) throws Exception {
        logger.info("---------- verify result content in folder: " + queryFolder);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            File expectResultFile = new File(sqlFile.getParent(), sqlFile.getName() + ".expected.xml");
            FlatXmlDataSet expect = new FlatXmlDataSetBuilder().build(expectResultFile);
            ITable expectTable = expect.getTable("expect");
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, false);
            this.assertTableEquals(expectTable, kylinTable);
        }
    }

    protected void execAndCompResultSize(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        logger.info("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, needSort);
            logger.info("Query Result from H2 - " + queryName);
            ITable h2Table = this.executeQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql, needSort);
            try {
                Assert.assertEquals((long)h2Table.getRowCount(), (long)kylinTable.getRowCount());
            }
            catch (Throwable t) {
                logger.info("execAndCompResultSize failed on: " + sqlFile.getAbsolutePath());
                throw t;
            }
            ++compQueryCount;
            if (kylinTable.getRowCount() != 0) continue;
            zeroResultQueries.add(sql);
        }
    }

    protected void execAndCompColumnCount(String input, int expectedColumnCount) throws Exception {
        logger.info("---------- test column count: " + input);
        ImmutableSet sqlSet = ImmutableSet.of((Object)input);
        for (String sql : sqlSet) {
            logger.info("Query Result from Kylin - " + sql);
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, sql, sql, false);
            try {
                Assert.assertEquals((long)expectedColumnCount, (long)kylinTable.getTableMetaData().getColumns().length);
            }
            catch (Throwable t) {
                logger.info("execAndCompColumnCount failed on: " + sql);
                throw t;
            }
        }
    }

    protected void execLimitAndValidate(String queryFolder) throws Exception {
        logger.info("---------- test folder: " + new File(queryFolder).getAbsolutePath());
        int appendLimitQueries = 0;
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String sqlWithLimit;
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            if (sql.toLowerCase(Locale.ROOT).contains("limit ")) {
                sqlWithLimit = sql;
            } else {
                sqlWithLimit = sql + " limit 5";
                ++appendLimitQueries;
            }
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sqlWithLimit, false);
            logger.info("Query Result from H2 - " + queryName);
            ITable h2Table = this.executeQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql, false);
            try {
                this.assertTableContains(h2Table, kylinTable);
            }
            catch (Throwable t) {
                logger.info("execAndCompQuery failed on: " + sqlFile.getAbsolutePath());
                throw t;
            }
            ++compQueryCount;
            if (kylinTable.getRowCount() != 0) continue;
            zeroResultQueries.add(sql);
        }
        logger.info("Queries appended with limit: " + appendLimitQueries);
    }

    protected void execAndCompQuery(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        this.execAndCompQuery(queryFolder, exclusiveQuerys, needSort, new ICompareQueryTranslator(){

            @Override
            public String transform(File f) {
                try {
                    return KylinTestBase.getTextFromFile(f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void execAndCompPlan(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        this.execAndCompPlan(queryFolder, exclusiveQuerys, needSort, new ICompareQueryTranslator(){

            @Override
            public String transform(File f) {
                try {
                    return KylinTestBase.getTextFromFile(f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    protected void execAndCompPlan(String queryFolder, String[] exclusiveQuerys, boolean needSort, ICompareQueryTranslator translator) throws Exception {
        logger.info("---------- test folder: " + new File(queryFolder).getAbsolutePath());
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql1 = KylinTestBase.getTextFromFile(sqlFile);
            String sql2 = translator.transform(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql1, needSort);
            RelNode calcitePlan = (RelNode)QueryContextFacade.current().getCalcitePlan();
            if (calcitePlan == null) {
                throw new NullPointerException();
            }
            logger.info("Query Result from H2 - " + queryName);
            long currentTime = System.currentTimeMillis();
            ITable h2Table = this.executeQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql2, needSort);
            logger.info("H2 spent " + (System.currentTimeMillis() - currentTime) + " mili-seconds.");
            try {
                this.assertTableEquals(h2Table, kylinTable);
            }
            catch (Throwable t) {
                logger.info("execAndCompQuery failed on: " + sqlFile.getAbsolutePath());
                throw t;
            }
            RelToSqlConverter converter = new RelToSqlConverter(SqlDialect.CALCITE);
            SqlNode sqlNode = converter.visitChild(0, calcitePlan.getInput(0)).asStatement();
            String optimizedSQL = sqlNode.toSqlString(SqlDialect.CALCITE).getSql();
            String expectedSQL = Strings.join((Iterable)Files.readLines((File)new File(sqlFile.getParent(), sqlFile.getName() + ".expected"), (Charset)Charset.forName("utf-8")), (String)"\n");
            Assert.assertEquals((Object)expectedSQL, (Object)optimizedSQL);
            ++compQueryCount;
            if (kylinTable.getRowCount() != 0) continue;
            zeroResultQueries.add(sql1);
        }
    }

    protected void execAndCompQuery(String queryFolder, String[] exclusiveQuerys, boolean needSort, ICompareQueryTranslator translator) throws Exception {
        logger.info("---------- test folder: " + new File(queryFolder).getAbsolutePath());
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql1 = KylinTestBase.getTextFromFile(sqlFile);
            String sql2 = translator.transform(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql1, needSort);
            logger.info("Query Result from H2 - " + queryName);
            long currentTime = System.currentTimeMillis();
            ITable h2Table = this.executeQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql2, needSort);
            logger.info("H2 spent " + (System.currentTimeMillis() - currentTime) + " mili-seconds.");
            try {
                this.assertTableEquals(h2Table, kylinTable);
            }
            catch (Throwable t) {
                logger.info("execAndCompQuery failed on: " + sqlFile.getAbsolutePath());
                throw t;
            }
            ++compQueryCount;
            if (kylinTable.getRowCount() != 0) continue;
            zeroResultQueries.add(sql1);
        }
    }

    protected void execAndCompDynamicQuery(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        logger.info("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = KylinTestBase.getTextFromFile(sqlFile);
            List<String> parameters = KylinTestBase.getParameterFromFile(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeDynamicQuery((IDatabaseConnection)kylinConn, queryName, sql, parameters, needSort);
            logger.info("Query Result from H2 - " + queryName);
            ITable h2Table = this.executeDynamicQuery((IDatabaseConnection)KylinTestBase.newH2Connection(), queryName, sql, parameters, needSort);
            this.assertTableEquals(h2Table, kylinTable);
        }
    }

    protected void assertTableEquals(ITable h2Table, ITable kylinTable) throws DatabaseUnitException {
        HackedDbUnitAssert dbUnit = new HackedDbUnitAssert();
        dbUnit.hackIgnoreIntBigIntMismatch();
        dbUnit.assertEquals(h2Table, kylinTable);
    }

    protected void assertTableContains(ITable h2Table, ITable kylinTable) throws DatabaseUnitException {
        HackedDbUnitAssert dbUnit = new HackedDbUnitAssert();
        dbUnit.hackIgnoreIntBigIntMismatch();
        dbUnit.hackCheckContains();
        dbUnit.assertEquals(h2Table, kylinTable);
    }

    protected static H2Connection newH2Connection() throws DatabaseUnitException {
        H2Connection h2Conn = new H2Connection(h2Connection, null);
        h2Conn.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new TestH2DataTypeFactory());
        h2Conn.getConfig().setFeature("http://www.dbunit.org/features/datatypeWarning", false);
        return h2Conn;
    }

    protected int runSqlFile(String file) throws Exception {
        return this.runSQL(new File(file), true, false);
    }

    protected int runSQL(File sqlFile, boolean debug, boolean explain) throws Exception {
        if (debug) {
            System.setProperty("calcite.debug", "true");
            FileInputStream inputStream = new FileInputStream("src/test/resources/logging.properties");
            LogManager.getLogManager().readConfiguration(inputStream);
        }
        String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
        logger.info("Testing Query " + queryName);
        String sql = KylinTestBase.getTextFromFile(sqlFile);
        if (explain) {
            sql = "explain plan for " + sql;
        }
        int count = this.executeQuery(sql, true);
        if (debug) {
            System.clearProperty("calcite.debug");
        }
        return count;
    }

    protected void batchExecuteQuery(String queryFolder) throws Exception {
        List<File> sqlFiles = KylinTestBase.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            this.runSQL(sqlFile, false, false);
        }
    }

    protected int output(ResultSet resultSet, boolean needDisplay) throws SQLException {
        int i;
        int count = 0;
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        StringBuilder sb = new StringBuilder("\n");
        if (needDisplay) {
            for (i = 1; i <= columnCount; ++i) {
                sb.append(metaData.getColumnName(i));
                sb.append("-");
                sb.append(metaData.getTableName(i));
                sb.append("-");
                sb.append(metaData.getColumnTypeName(i));
                if (i < columnCount) {
                    sb.append("\t");
                    continue;
                }
                sb.append("\n");
            }
        }
        while (resultSet.next()) {
            if (needDisplay) {
                for (i = 1; i <= columnCount; ++i) {
                    sb.append(resultSet.getString(i));
                    if (i < columnCount) {
                        sb.append("\t");
                        continue;
                    }
                    sb.append("\n");
                }
            }
            ++count;
        }
        logger.info(sb.toString());
        return count;
    }

    protected static void setupAll() throws Exception {
        HBaseMetadataTestCase.staticCreateTestMetadata();
        config = KylinConfig.getInstanceFromEnv();
        String project = "default";
        cubeConnection = QueryConnection.getConnection((String)project);
        h2Connection = DriverManager.getConnection("jdbc:h2:mem:db" + h2InstanceCount++ + ";CACHE_SIZE=32072", "sa", "");
        H2Database h2DB = new H2Database(h2Connection, config, project);
        h2DB.loadAllTables();
    }

    protected static void clean() {
        if (cubeConnection != null) {
            KylinTestBase.closeConnection(cubeConnection);
        }
        if (h2Connection != null) {
            KylinTestBase.closeConnection(h2Connection);
        }
        HBaseMetadataTestCase.staticCleanupTestMetadata();
        RemoveBlackoutRealizationsRule.blackList.clear();
    }

    protected boolean checkFinalPushDownLimit() {
        OLAPContext context = this.getFirstOLAPContext();
        return context.storageContext.isLimitPushDownEnabled();
    }

    private OLAPContext getFirstOLAPContext() {
        return (OLAPContext)OLAPContext.getThreadLocalContexts().iterator().next();
    }

    protected String getQueryFolderPrefix() {
        return "";
    }

    protected Throwable findRoot(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    static {
        System.setProperty("needCheckCC", "true");
        logger = LoggerFactory.getLogger(KylinTestBase.class);
        PRINT_RESULT = false;
        config = null;
        cubeConnection = null;
        h2Connection = null;
        joinType = "default";
        h2InstanceCount = 0;
        compQueryCount = 0;
        zeroResultQueries = new ArrayList();
        ITDirHeader = "";
    }

    private static class FileByNameComparator
    implements Comparator<File> {
        private FileByNameComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName());
        }
    }

    public static class TestH2DataTypeFactory
    extends H2DataTypeFactory {
        public DataType createDataType(int sqlType, String sqlTypeName, String tableName, String columnName) throws DataTypeException {
            if ((columnName.startsWith("COL") || columnName.startsWith("col")) && sqlType == -5) {
                return DataType.INTEGER;
            }
            return super.createDataType(sqlType, sqlTypeName);
        }
    }

    class ObjectArray {
        Object[] data;

        public ObjectArray(Object[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectArray that = (ObjectArray)o;
            return Arrays.equals(this.data, that.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

