/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.query.ITKylinQueryTest;
import org.apache.kylin.query.KylinTestBase;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.ITable;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITMassInQueryTest
extends KylinTestBase {
    private static final Logger logger = LoggerFactory.getLogger(ITMassInQueryTest.class);
    FileSystem fileSystem;
    Set<Long> vipSellers;

    @BeforeClass
    public static void setUp() throws SQLException {
    }

    @AfterClass
    public static void tearDown() {
    }

    @Before
    public void setup() throws Exception {
        ITKylinQueryTest.clean();
        ITKylinQueryTest.joinType = "left";
        ITKylinQueryTest.setupAll();
        this.fileSystem = HadoopUtil.getWorkingFileSystem();
        int sellerCount = 200;
        Random r = new Random();
        this.vipSellers = Sets.newHashSet();
        for (int i = 0; i < sellerCount; ++i) {
            this.vipSellers.add(10000000L + (long)r.nextInt(1500));
        }
        Path path = new Path("/tmp/vip_customers.txt");
        this.fileSystem.delete(path, false);
        FSDataOutputStream outputStream = this.fileSystem.create(path);
        IOUtils.write((String)org.apache.commons.lang3.StringUtils.join(this.vipSellers, (String)"\n"), (OutputStream)outputStream, (Charset)Charset.defaultCharset());
        outputStream.close();
        System.out.println("The filter is " + this.vipSellers);
    }

    @After
    public void after() throws Exception {
        ITKylinQueryTest.clean();
    }

    @Test
    @Ignore
    public void testMassInQuery() throws Exception {
        this.compare("src/test/resources/query/sql_massin", null, true);
    }

    @Test
    @Ignore
    public void testMassInWithDistinctCount() throws Exception {
        this.run("src/test/resources/query/sql_massin_distinct", null, true);
    }

    protected void run(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        logger.info("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = ITMassInQueryTest.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = org.apache.commons.lang3.StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = ITMassInQueryTest.getTextFromFile(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, needSort);
            ITMassInQueryTest.printResult(kylinTable);
        }
    }

    protected void compare(String queryFolder, String[] exclusiveQuerys, boolean needSort) throws Exception {
        logger.info("---------- test folder: " + queryFolder);
        Set<String> exclusiveSet = this.buildExclusiveSet(exclusiveQuerys);
        List<File> sqlFiles = ITMassInQueryTest.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = org.apache.commons.lang3.StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            if (exclusiveSet.contains(queryName)) continue;
            String sql = ITMassInQueryTest.getTextFromFile(sqlFile);
            logger.info("Query Result from Kylin - " + queryName + "  (" + queryFolder + ")");
            DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
            ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, needSort);
            sql = sql.replace("massin(test_kylin_fact.SELLER_ID,'vip_customers')", "test_kylin_fact.SELLER_ID in ( " + StringUtils.join(this.vipSellers, (String)",") + ")");
            logger.info("Query Result from H2 - " + queryName);
            logger.info("Query for H2 - " + sql);
            ITable h2Table = this.executeQuery((IDatabaseConnection)ITMassInQueryTest.newH2Connection(), queryName, sql, needSort);
            try {
                this.assertTableEquals(h2Table, kylinTable);
            }
            catch (Throwable t) {
                logger.info("execAndCompQuery failed on: " + sqlFile.getAbsolutePath());
                throw t;
            }
        }
    }
}

