/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.collect.Maps;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.KylinTestBase;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.rules.RemoveBlackoutRealizationsRule;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.ITable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="KylinQueryTest is contained by ITCombinationTest")
public class ITKylinQueryTest
extends KylinTestBase {
    private static final Logger logger = LoggerFactory.getLogger(ITKylinQueryTest.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws Exception {
        logger.info("setUp in ITKylinQueryTest");
        HashMap priorities = Maps.newHashMap();
        priorities.put(RealizationType.HYBRID, 0);
        priorities.put(RealizationType.CUBE, 0);
        priorities.put(RealizationType.INVERTED_INDEX, 0);
        Candidate.setPriorities((Map)priorities);
        joinType = "left";
        ITKylinQueryTest.setupAll();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        logger.info("tearDown in ITKylinQueryTest");
        Candidate.restorePriorities();
        ITKylinQueryTest.clean();
    }

    @Test
    public void testTimeoutQuery() throws Exception {
        try {
            HashMap toggles = Maps.newHashMap();
            toggles.put("DEBUG_TOGGLE_COPROCESSOR_BEHAVIOR", StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM_WITHDELAY.toString());
            BackdoorToggles.setToggles((Map)toggles);
            KylinConfig.getInstanceFromEnv().setProperty("kylin.storage.hbase.coprocessor-timeout-seconds", "3");
            RemoveBlackoutRealizationsRule.blackList.add("CUBE[name=test_kylin_cube_without_slr_left_join_empty]");
            RemoveBlackoutRealizationsRule.blackList.add("CUBE[name=test_kylin_cube_without_slr_inner_join_empty]");
            this.runTimeoutQueries();
        }
        finally {
            RemoveBlackoutRealizationsRule.blackList.remove("CUBE[name=test_kylin_cube_without_slr_left_join_empty]");
            RemoveBlackoutRealizationsRule.blackList.remove("CUBE[name=test_kylin_cube_without_slr_inner_join_empty]");
            KylinConfig.getInstanceFromEnv().setProperty("kylin.storage.hbase.coprocessor-timeout-seconds", "0");
            BackdoorToggles.cleanToggles();
        }
    }

    protected void runTimeoutQueries() throws Exception {
        List<File> sqlFiles = ITKylinQueryTest.getFilesFromFolder(new File(this.getQueryFolderPrefix() + "src/test/resources/query/sql_timeout"), ".sql");
        for (File sqlFile : sqlFiles) {
            try {
                this.runSQL(sqlFile, false, false);
            }
            catch (SQLException e) {
                if (this.findRoot(e) instanceof KylinTimeoutException) continue;
            }
            throw new RuntimeException("Expecting KylinTimeoutException");
        }
    }

    @Test
    public void testTempQuery() throws Exception {
        try {
            PRINT_RESULT = true;
            this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/temp", null, true);
        }
        finally {
            PRINT_RESULT = false;
        }
    }

    @Test
    public void testSingleRunQuery() throws Exception {
        System.setProperty("log4j.configuration", "file:../build/conf/kylin-tools-log4j.properties");
        String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql_verifyCount/query02.sql";
        File sqlFile = new File(queryFileName);
        if (sqlFile.exists()) {
            this.runSQL(sqlFile, true, false);
        }
    }

    @Ignore
    @Test
    public void testSingleExecuteQuery() throws Exception {
        String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql/query01.sql";
        File sqlFile = new File(queryFileName);
        String sql = ITKylinQueryTest.getTextFromFile(sqlFile);
        DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
        this.executeQuery((IDatabaseConnection)kylinConn, queryFileName, sql, true);
    }

    @Ignore
    @Test
    public void testTableauProbing() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/tableau_probing");
    }

    @Test
    public void testH2Uncapable() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_h2_uncapable");
    }

    @Test
    public void testCommonQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql", null, true);
    }

    @Test
    public void testSnowflakeQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_snowflake", null, true);
    }

    @Test
    public void testDateTimeQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_datetime", null, true);
    }

    @Test
    public void testExtendedColumnQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_extended_column", null, true);
    }

    @Test
    public void testLikeQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_like", null, true);
    }

    @Test
    public void testVerifyCountQuery() throws Exception {
        this.verifyResultRowColCount(this.getQueryFolderPrefix() + "src/test/resources/query/sql_verifyCount");
    }

    @Test
    public void testVerifyCountQueryWithPrepare() throws Exception {
        try {
            HashMap toggles = Maps.newHashMap();
            toggles.put("DEBUG_TOGGLE_PREPARE_ONLY", "true");
            BackdoorToggles.setToggles((Map)toggles);
            this.verifyResultRowColCount(this.getQueryFolderPrefix() + "src/test/resources/query/sql_verifyCount");
        }
        finally {
            BackdoorToggles.cleanToggles();
        }
    }

    @Test
    public void testVerifyContentQuery() throws Exception {
        this.verifyResultContent(this.getQueryFolderPrefix() + "src/test/resources/query/sql_verifyContent");
    }

    @Test
    public void testOrderByQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_orderby", null, true);
    }

    @Test
    public void testLookupQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_lookup", null, true);
    }

    @Test
    public void testJoinCastQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_join", null, true);
    }

    @Test
    public void testUnionQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_union", null, true);
    }

    @Test
    public void testUnionallQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_unionall", null, true);
    }

    @Test
    public void testTimeStampAdd() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_timestamp", null, true);
    }

    @Test
    public void testCachedQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_cache", null, true);
    }

    @Test
    public void testDerivedColumnQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_derived", null, true);
    }

    @Test
    public void testDistinctCountQuery() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_distinct");
    }

    @Test
    public void testTopNQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_topn", null, true);
    }

    @Test
    public void testPreciselyDistinctCountQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_distinct_precisely", null, true);
    }

    @Test
    public void testPreciselyDistinctCountRollupQuery() throws Exception {
        if ("left".equalsIgnoreCase(joinType)) {
            this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_distinct_precisely_rollup", null, true);
        }
    }

    @Test
    public void testIntersectCountQuery() throws Exception {
        if ("left".equalsIgnoreCase(joinType)) {
            this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_intersect_count");
        }
    }

    @Test
    public void testMultiModelQuery() throws Exception {
        if ("left".equalsIgnoreCase(joinType)) {
            joinType = "default";
            this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_multi_model", null, true);
            joinType = "left";
        }
    }

    @Test
    public void testDimDistinctCountQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_distinct_dim", null, true);
    }

    @Test
    public void testStreamingTableQuery() throws Exception {
        if ("inner".equalsIgnoreCase(joinType)) {
            this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_streaming", null, true);
        }
    }

    @Test
    public void testTableauQuery() throws Exception {
        this.execAndCompResultSize(this.getQueryFolderPrefix() + "src/test/resources/query/sql_tableau", null, true);
    }

    @Test
    public void testSubQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_subquery", null, true);
    }

    @Test
    public void testCaseWhen() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_casewhen", null, true);
    }

    @Ignore
    @Test
    public void testHiveQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_hive", null, true);
    }

    @Test
    public void testH2Query() throws Exception {
        this.execQueryUsingH2(this.getQueryFolderPrefix() + "src/test/resources/query/sql_orderby", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidQuery() throws Exception {
        logger.info("-------------------- Test Invalid Query --------------------");
        String queryFolder = this.getQueryFolderPrefix() + "src/test/resources/query/sql_invalid";
        List<File> sqlFiles = ITKylinQueryTest.getFilesFromFolder(new File(queryFolder), ".sql");
        for (File sqlFile : sqlFiles) {
            String queryName = StringUtils.split((String)sqlFile.getName(), (char)'.')[0];
            logger.info("Testing Query " + queryName);
            String sql = ITKylinQueryTest.getTextFromFile(sqlFile);
            DatabaseConnection cubeConn = new DatabaseConnection(cubeConnection);
            try {
                cubeConn.createQueryTable(queryName, sql);
            }
            catch (Throwable t) {}
            continue;
            finally {
                cubeConn.close();
                continue;
            }
            throw new IllegalStateException(queryName + " should be error!");
        }
    }

    @Test
    public void testDynamicQuery() throws Exception {
        this.execAndCompDynamicQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_dynamic", null, true);
    }

    @Test
    public void testLimitEnabled() throws Exception {
        List<File> sqlFiles = ITKylinQueryTest.getFilesFromFolder(new File(this.getQueryFolderPrefix() + "src/test/resources/query/sql_limit"), ".sql");
        for (File sqlFile : sqlFiles) {
            this.runSQL(sqlFile, false, false);
            if (sqlFile.getAbsolutePath().contains("query06.sql")) {
                Assert.assertTrue((!this.checkFinalPushDownLimit() ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((boolean)this.checkFinalPushDownLimit());
        }
    }

    @Test
    public void testLimitCorrectness() throws Exception {
        this.execLimitAndValidate(this.getQueryFolderPrefix() + "src/test/resources/query/sql");
    }

    @Test
    public void testRawQuery() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_raw", null, true);
    }

    @Test
    public void testGroupingQuery() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_grouping");
    }

    @Test
    public void testWindowQuery() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_window");
    }

    @Test
    public void testVersionQuery() throws Exception {
        String expectVersion = KylinVersion.getCurrentVersion().toString();
        logger.info("---------- verify expect version: " + expectVersion);
        String queryName = "QueryKylinVersion";
        String sql = "SELECT VERSION() AS version";
        logger.info("Query Result from Kylin - " + queryName);
        DatabaseConnection kylinConn = new DatabaseConnection(cubeConnection);
        ITable kylinTable = this.executeQuery((IDatabaseConnection)kylinConn, queryName, sql, false);
        String queriedVersion = String.valueOf(kylinTable.getValue(0, "version"));
        Assert.assertEquals((Object)expectVersion, (Object)queriedVersion);
    }

    @Test
    public void testPercentileQuery() throws Exception {
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_percentile");
    }

    @Test
    public void testExpressionQuery() throws Exception {
        boolean ifDynamicColumnEnabled = config.isDynamicColumnEnabled();
        if (!ifDynamicColumnEnabled) {
            config.setProperty("kylin.query.enable-dynamic-column", "true");
        }
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_expression");
        if (!ifDynamicColumnEnabled) {
            config.setProperty("kylin.query.enable-dynamic-column", "false");
        }
    }

    @Test
    public void testDictionaryEnumerator() throws Exception {
        boolean ifDictEnumeratorEnabled = config.isDictionaryEnumeratorEnabled();
        if (!ifDictEnumeratorEnabled) {
            config.setProperty("kylin.query.enable-dict-enumerator", "true");
        }
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_dict_enumerator");
        if (!ifDictEnumeratorEnabled) {
            config.setProperty("kylin.query.enable-dict-enumerator", "false");
        }
    }

    @Test
    public void testOrdinalQuery() throws Exception {
        String sqlConformance = config.getCalciteExtrasProperties().getProperty("conformance");
        if (!"LENIENT".equalsIgnoreCase(sqlConformance)) {
            config.setProperty("kylin.query.calcite.extras-props.conformance", "LENIENT");
        }
        this.batchExecuteQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_ordinal");
        if (!"LENIENT".equalsIgnoreCase(sqlConformance)) {
            config.setProperty("kylin.query.calcite.extras-props.conformance", sqlConformance);
        }
    }

    @Test
    public void testValues() throws Exception {
        this.execAndCompQuery(this.getQueryFolderPrefix() + "src/test/resources/query/sql_values", null, true);
    }

    @Test
    public void testPlan() throws Exception {
        String originProp = System.getProperty("calcite.debug");
        System.setProperty("calcite.debug", "true");
        this.execAndCompPlan(this.getQueryFolderPrefix() + "src/test/resources/query/sql_plan", null, true);
        if (originProp == null || "false".equals(originProp)) {
            System.setProperty("calcite.debug", "false");
        }
    }
}

