/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContextFacade;
import org.apache.kylin.common.exceptions.ResourceLimitExceededException;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.KylinTestBase;
import org.apache.kylin.query.routing.Candidate;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITFailfastQueryTest
extends KylinTestBase {
    private static final Logger logger = LoggerFactory.getLogger(ITFailfastQueryTest.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @BeforeClass
    public static void setUp() throws Exception {
        logger.info("setUp in ITFailfastQueryTest");
        HashMap priorities = Maps.newHashMap();
        priorities.put(RealizationType.HYBRID, 0);
        priorities.put(RealizationType.CUBE, 0);
        priorities.put(RealizationType.INVERTED_INDEX, 0);
        Candidate.setPriorities((Map)priorities);
        joinType = "left";
        ITFailfastQueryTest.setupAll();
    }

    @After
    public void cleanUp() {
        QueryContextFacade.resetCurrent();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        logger.info("tearDown in ITFailfastQueryTest");
        Candidate.restorePriorities();
        ITFailfastQueryTest.clean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionExceedMaxScanBytes() throws Exception {
        String key = "kylin.storage.partition.max-scan-bytes";
        long saved = KylinConfig.getInstanceFromEnv().getPartitionMaxScanBytes();
        KylinConfig.getInstanceFromEnv().setProperty(key, "1000");
        boolean meetExpectedException = false;
        try {
            String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql/query01.sql";
            File sqlFile = new File(queryFileName);
            try {
                this.runSQL(sqlFile, false, false);
            }
            catch (Exception e) {
                if (this.findRoot(e) instanceof ResourceLimitExceededException) {
                    meetExpectedException = true;
                }
                throw new RuntimeException(e);
            }
            if (!meetExpectedException) {
                throw new RuntimeException("Did not meet expected exception");
            }
        }
        finally {
            KylinConfig.getInstanceFromEnv().setProperty(key, String.valueOf(saved));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartitionNotExceedMaxScanBytes() throws Exception {
        String key = "kylin.storage.partition.max-scan-bytes";
        long saved = KylinConfig.getInstanceFromEnv().getPartitionMaxScanBytes();
        KylinConfig.getInstanceFromEnv().setProperty(key, "100000");
        try {
            String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql/query01.sql";
            File sqlFile = new File(queryFileName);
            this.runSQL(sqlFile, false, false);
        }
        finally {
            KylinConfig.getInstanceFromEnv().setProperty(key, String.valueOf(saved));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryExceedMaxScanBytes() throws Exception {
        String key = "kylin.query.max-scan-bytes";
        long saved = KylinConfig.getInstanceFromEnv().getQueryMaxScanBytes();
        KylinConfig.getInstanceFromEnv().setProperty(key, "1000");
        boolean meetExpectedException = false;
        try {
            String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql/query01.sql";
            File sqlFile = new File(queryFileName);
            try {
                this.runSQL(sqlFile, false, false);
            }
            catch (Exception e) {
                if (this.findRoot(e) instanceof ResourceLimitExceededException) {
                    meetExpectedException = true;
                }
                throw new RuntimeException(e);
            }
            if (!meetExpectedException) {
                throw new RuntimeException("Did not meet expected exception");
            }
        }
        finally {
            KylinConfig.getInstanceFromEnv().setProperty(key, String.valueOf(saved));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryNotExceedMaxScanBytes() throws Exception {
        String key = "kylin.query.max-scan-bytes";
        long saved = KylinConfig.getInstanceFromEnv().getQueryMaxScanBytes();
        KylinConfig.getInstanceFromEnv().setProperty(key, "100000");
        try {
            String queryFileName = this.getQueryFolderPrefix() + "src/test/resources/query/sql/query01.sql";
            File sqlFile = new File(queryFileName);
            this.runSQL(sqlFile, false, false);
        }
        finally {
            KylinConfig.getInstanceFromEnv().setProperty(key, String.valueOf(saved));
        }
    }
}

