/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.query.ITKylinQueryTest;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.rules.RemoveBlackoutRealizationsRule;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class ITCombinationTest
extends ITKylinQueryTest {
    private static final Logger logger = LoggerFactory.getLogger(ITCombinationTest.class);

    @BeforeClass
    public static void setUp() {
        HashMap priorities = Maps.newHashMap();
        priorities.put(RealizationType.HYBRID, 0);
        priorities.put(RealizationType.CUBE, 0);
        Candidate.setPriorities((Map)priorities);
        logger.info("setUp in ITCombinationTest");
    }

    @AfterClass
    public static void tearDown() {
        logger.info("tearDown in ITCombinationTest");
        ITCombinationTest.clean();
        Candidate.restorePriorities();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({"inner", "on", "v2"}, {"left", "on", "v2"});
    }

    public ITCombinationTest(String joinType, String coprocessorToggle, String queryEngine) throws Exception {
        logger.info("Into combination join type: " + joinType + ", coprocessor toggle: " + coprocessorToggle + ", query engine: " + queryEngine);
        ITKylinQueryTest.clean();
        ITKylinQueryTest.joinType = joinType;
        ITKylinQueryTest.setupAll();
        RemoveBlackoutRealizationsRule.blackList.clear();
    }
}

