/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DbUnitAssert;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.BigIntegerDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.IntegerDataType;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackedDbUnitAssert
extends DbUnitAssert {
    private static final Logger logger = LoggerFactory.getLogger(HackedDbUnitAssert.class);
    private boolean hackCheckContains;
    private boolean hackIgnoreIntBigIntMismatch;

    public void hackCheckContains() {
        this.hackCheckContains = true;
    }

    public void hackIgnoreIntBigIntMismatch() {
        this.hackIgnoreIntBigIntMismatch = true;
    }

    public void assertEquals(ITable expectedTable, ITable actualTable, FailureHandler failureHandler) throws DatabaseUnitException {
        logger.trace("assertEquals(expectedTable, actualTable, failureHandler) - start");
        logger.debug("assertEquals: expectedTable={}", (Object)expectedTable);
        logger.debug("assertEquals: actualTable={}", (Object)actualTable);
        logger.debug("assertEquals: failureHandler={}", (Object)failureHandler);
        if (expectedTable == actualTable) {
            logger.debug("The given tables reference the same object. Will return immediately. (Table={})", (Object)expectedTable);
            return;
        }
        if (failureHandler == null) {
            logger.debug("FailureHandler is null. Using default implementation");
            failureHandler = this.getDefaultFailureHandler();
        }
        ITableMetaData expectedMetaData = expectedTable.getTableMetaData();
        ITableMetaData actualMetaData = actualTable.getTableMetaData();
        String expectedTableName = expectedMetaData.getTableName();
        int expectedRowsCount = expectedTable.getRowCount();
        int actualRowsCount = actualTable.getRowCount();
        if (!this.hackCheckContains && expectedRowsCount != actualRowsCount) {
            String msg = "row count (table=" + expectedTableName + ")";
            Error error = failureHandler.createFailure(msg, String.valueOf(expectedRowsCount), String.valueOf(actualRowsCount));
            logger.error(error.toString());
            throw error;
        }
        if (expectedRowsCount == 0 && actualRowsCount == 0) {
            logger.debug("Tables are empty, hence equals.");
            return;
        }
        Column[] expectedColumns = Columns.getSortedColumns((ITableMetaData)expectedMetaData);
        Column[] actualColumns = Columns.getSortedColumns((ITableMetaData)actualMetaData);
        Columns.ColumnDiff columnDiff = Columns.getColumnDiff((ITableMetaData)expectedMetaData, (ITableMetaData)actualMetaData);
        if (columnDiff.hasDifference()) {
            String message = columnDiff.getMessage();
            Error error = failureHandler.createFailure(message, Columns.getColumnNamesAsString((Column[])expectedColumns), Columns.getColumnNamesAsString((Column[])actualColumns));
            logger.error(error.toString());
            throw error;
        }
        DbUnitAssert.ComparisonColumn[] comparisonCols = this.getComparisonColumns(expectedTableName, expectedColumns, actualColumns, failureHandler);
        if (this.hackCheckContains) {
            this.compareDataContains(expectedTable, actualTable, comparisonCols, failureHandler);
        } else {
            this.compareData(expectedTable, actualTable, comparisonCols, failureHandler);
        }
    }

    protected DbUnitAssert.ComparisonColumn[] getComparisonColumns(String expectedTableName, Column[] expectedColumns, Column[] actualColumns, FailureHandler failureHandler) {
        DbUnitAssert.ComparisonColumn[] result = new DbUnitAssert.ComparisonColumn[expectedColumns.length];
        for (int j = 0; j < expectedColumns.length; ++j) {
            Column expectedColumn = expectedColumns[j];
            Column actualColumn = actualColumns[j];
            result[j] = new HackedComparisonColumn(expectedTableName, expectedColumn, actualColumn, failureHandler);
        }
        return result;
    }

    private void compareDataContains(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler) throws DataSetException {
        logger.debug("compareData(expectedTable={}, actualTable={}, comparisonCols={}, failureHandler={}) - start", new Object[]{expectedTable, actualTable, comparisonCols, failureHandler});
        if (expectedTable == null) {
            throw new NullPointerException("The parameter 'expectedTable' must not be null");
        }
        if (actualTable == null) {
            throw new NullPointerException("The parameter 'actualTable' must not be null");
        }
        if (comparisonCols == null) {
            throw new NullPointerException("The parameter 'comparisonCols' must not be null");
        }
        if (failureHandler == null) {
            throw new NullPointerException("The parameter 'failureHandler' must not be null");
        }
        for (int index = 0; index < actualTable.getRowCount(); ++index) {
            if (this.findRowInExpectedTable(expectedTable, actualTable, comparisonCols, failureHandler, index)) continue;
            throw new IllegalStateException();
        }
    }

    private boolean findRowInExpectedTable(ITable expectedTable, ITable actualTable, DbUnitAssert.ComparisonColumn[] comparisonCols, FailureHandler failureHandler, int index) throws DataSetException {
        block0: for (int i = 0; i < expectedTable.getRowCount(); ++i) {
            for (int j = 0; j < comparisonCols.length; ++j) {
                Object actualValue;
                DbUnitAssert.ComparisonColumn compareColumn = comparisonCols[j];
                String columnName = compareColumn.getColumnName();
                DataType dataType = compareColumn.getDataType();
                Object expectedValue = expectedTable.getValue(i, columnName);
                if (this.skipCompare(columnName, expectedValue, actualValue = actualTable.getValue(index, columnName))) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("ignoring comparison " + expectedValue + "=" + actualValue + " on column " + columnName);
                    continue;
                }
                if (dataType.compare(expectedValue, actualValue) != 0) continue block0;
                if (j != comparisonCols.length - 1) continue;
                return true;
            }
        }
        return false;
    }

    private class HackedComparisonColumn
    extends DbUnitAssert.ComparisonColumn {
        private String columnName;
        private DataType dataType;

        public HackedComparisonColumn(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            super(tableName, expectedColumn, expectedColumn, failureHandler);
            this.columnName = expectedColumn.getColumnName();
            this.dataType = this.getComparisonDataType(tableName, expectedColumn, actualColumn, failureHandler);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        private DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            if (logger.isDebugEnabled()) {
                logger.debug("getComparisonDataType(tableName={}, expectedColumn={}, actualColumn={}, failureHandler={}) - start", new Object[]{tableName, expectedColumn, actualColumn, failureHandler});
            }
            DataType expectedDataType = expectedColumn.getDataType();
            DataType actualDataType = actualColumn.getDataType();
            if (!expectedDataType.getClass().isInstance(actualDataType)) {
                if (expectedDataType instanceof UnknownDataType) {
                    return actualDataType;
                }
                if (actualDataType instanceof UnknownDataType) {
                    return expectedDataType;
                }
                if (HackedDbUnitAssert.this.hackIgnoreIntBigIntMismatch && expectedDataType instanceof IntegerDataType && actualDataType instanceof BigIntegerDataType) {
                    return actualDataType;
                }
                String msg = "Incompatible data types: (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")";
                throw failureHandler.createFailure(msg, String.valueOf(expectedDataType), String.valueOf(actualDataType));
            }
            return expectedDataType;
        }
    }
}

