/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.provision;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.BatchOptimizeJobCheckpointBuilder;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.job.DeployUtil;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.impl.threadpool.DefaultScheduler;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.job.lock.zookeeper.ZookeeperJobLock;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.rest.job.StorageCleanupJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.HBaseRegionSizeCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildCubeWithEngine {
    private CubeManager cubeManager;
    private CubeDescManager cubeDescManager;
    private DefaultScheduler scheduler;
    protected ExecutableManager jobService;
    private static boolean fastBuildMode = false;
    private static int engineType;
    private static final Logger logger;

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        int exitCode = 0;
        try {
            BuildCubeWithEngine.beforeClass();
            BuildCubeWithEngine buildCubeWithEngine = new BuildCubeWithEngine();
            buildCubeWithEngine.before();
            buildCubeWithEngine.build();
            buildCubeWithEngine.after();
            logger.info("Build is done");
            BuildCubeWithEngine.afterClass();
            logger.info("Going to exit");
        }
        catch (Throwable e) {
            logger.error("error", e);
            exitCode = 1;
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("Time elapsed: " + millis / 1000L + " sec - in " + BuildCubeWithEngine.class.getName());
        System.exit(exitCode);
    }

    public static void beforeClass() throws Exception {
        BuildCubeWithEngine.beforeClass(HBaseMetadataTestCase.SANDBOX_TEST_DATA);
    }

    public static void beforeClass(String confDir) throws Exception {
        logger.info("Adding to classpath: " + new File(confDir).getAbsolutePath());
        ClassUtil.addClasspath((String)new File(confDir).getAbsolutePath());
        fastBuildMode = BuildCubeWithEngine.isFastBuildMode();
        if (fastBuildMode) {
            logger.info("Will use fast build mode");
        } else {
            logger.info("Will not use fast build mode");
        }
        String specifiedEngineType = System.getProperty("engineType");
        engineType = StringUtils.isNotEmpty((CharSequence)specifiedEngineType) ? Integer.parseInt(specifiedEngineType) : 2;
        System.setProperty("KYLIN_CONF", confDir);
        System.setProperty("SPARK_HOME", "/usr/local/spark");
        System.setProperty("kylin.hadoop.conf.dir", confDir);
        if (StringUtils.isEmpty((CharSequence)System.getProperty("hdp.version"))) {
            throw new RuntimeException("No hdp.version set; Please set hdp.version in your jvm option, for example: -Dhdp.version=2.4.0.0-169");
        }
        HBaseMetadataTestCase.staticCreateTestMetadata((String)confDir);
        try {
            FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
            String hdfsWorkingDirectory = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
            Path coprocessorDir = new Path(hdfsWorkingDirectory);
            boolean success = fileSystem.mkdirs(coprocessorDir);
            if (!success) {
                throw new IOException("mkdir fails");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create kylin.env.hdfs-working-dir, Please make sure the user has right to access " + KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory(), e);
        }
    }

    private static boolean isFastBuildMode() {
        String fastModeStr = System.getProperty("fastBuildMode");
        if (fastModeStr == null) {
            fastModeStr = System.getenv("KYLIN_CI_FASTBUILD");
        }
        return "true".equalsIgnoreCase(fastModeStr);
    }

    protected void deployEnv() throws IOException {
        DeployUtil.initCliWorkDir();
        DeployUtil.deployMetadata();
        DeployUtil.overrideJobJarLocations();
    }

    public void before() throws Exception {
        this.deployEnv();
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.jobService = ExecutableManager.getInstance((KylinConfig)kylinConfig);
        this.scheduler = DefaultScheduler.createInstance();
        this.scheduler.init(new JobEngineConfig(kylinConfig), (JobLock)new ZookeeperJobLock());
        if (!this.scheduler.hasStarted()) {
            throw new RuntimeException("scheduler has not been started");
        }
        this.cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        for (String jobId : this.jobService.getAllJobIds()) {
            AbstractExecutable executable = this.jobService.getJob(jobId);
            if (!(executable instanceof CubingJob) && !(executable instanceof CheckpointExecutable)) continue;
            this.jobService.deleteJob(jobId);
        }
        this.cubeDescManager = CubeDescManager.getInstance((KylinConfig)kylinConfig);
    }

    public void after() {
        DefaultScheduler.destroyInstance();
    }

    public static void afterClass() {
        HBaseMetadataTestCase.staticCleanupTestMetadata();
    }

    public void build() throws Exception {
        DeployUtil.prepareTestDataForNormalCubes((String)"ci_left_join_model");
        System.setProperty("kylin.storage.hbase.hfile-size-gb", "1.0f");
        this.testCase("testInnerJoinCube");
        this.testCase("testLeftJoinCube");
        this.testCase("testTableExt");
        this.testCase("testModel");
        System.setProperty("kylin.storage.hbase.hfile-size-gb", "0.0f");
    }

    protected ExecutableState waitForJob(String jobId) {
        AbstractExecutable job;
        while ((job = this.jobService.getJob(jobId)).getStatus() != ExecutableState.SUCCEED && job.getStatus() != ExecutableState.ERROR) {
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return job.getStatus();
    }

    private void testCase(String ... testCase) throws Exception {
        this.runTestAndAssertSucceed(testCase);
    }

    private void runTestAndAssertSucceed(String[] testCase) throws Exception {
        int i;
        ExecutorService executorService = Executors.newFixedThreadPool(testCase.length);
        CountDownLatch countDownLatch = new CountDownLatch(testCase.length);
        ArrayList tasks = Lists.newArrayListWithExpectedSize((int)testCase.length);
        for (i = 0; i < testCase.length; ++i) {
            tasks.add(executorService.submit(new TestCallable(testCase[i], countDownLatch)));
        }
        countDownLatch.await();
        try {
            for (i = 0; i < tasks.size(); ++i) {
                Future task = (Future)tasks.get(i);
                Boolean result = (Boolean)task.get();
                if (result.booleanValue()) continue;
                throw new RuntimeException("The test '" + testCase[i] + "' is failed.");
            }
        }
        catch (Exception ex) {
            logger.error("error", (Throwable)ex);
            throw ex;
        }
    }

    protected boolean testTableExt() throws Exception {
        return true;
    }

    protected boolean testModel() throws Exception {
        return true;
    }

    private boolean testLeftJoinCube() throws Exception {
        String cubeName = "ci_left_join_cube";
        this.clearSegment(cubeName);
        return this.doBuildAndMergeOnCube(cubeName);
    }

    private boolean doBuildAndMergeOnCube(String cubeName) throws ParseException, Exception {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        long date1 = 0L;
        long date2 = f.parse("2012-06-01").getTime();
        long date3 = f.parse("2013-07-01").getTime();
        long date4 = f.parse("2022-01-01").getTime();
        long date5 = f.parse("2023-01-01").getTime();
        long date6 = f.parse("2024-01-01").getTime();
        if (fastBuildMode) {
            return this.buildSegment(cubeName, date1, date4);
        }
        if (!this.buildSegment(cubeName, date1, date2).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.buildSegment(cubeName, date2, date3).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.optimizeCube(cubeName).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.buildSegment(cubeName, date3, date4).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.buildSegment(cubeName, date4, date5).booleanValue()) {
            return false;
        }
        this.checkEmptySegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.buildSegment(cubeName, date5, date6).booleanValue()) {
            return false;
        }
        this.checkEmptySegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.mergeSegment(cubeName, date2, date4).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        if (!this.mergeSegment(cubeName, date2, date5).booleanValue()) {
            return false;
        }
        this.checkNormalSegRangeInfo(this.cubeManager.getCube(cubeName));
        return true;
    }

    private boolean testInnerJoinCube() throws Exception {
        String cubeName = "ci_inner_join_cube";
        this.clearSegment(cubeName);
        return this.doBuildAndMergeOnCube(cubeName);
    }

    private void updateCubeEngineType(String cubeName) throws IOException {
        CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(cubeName);
        if (cubeDesc.getEngineType() != engineType) {
            cubeDesc.setEngineType(engineType);
            this.cubeDescManager.updateCubeDesc(cubeDesc);
        }
    }

    private void clearSegment(String cubeName) throws Exception {
        CubeInstance cube = this.cubeManager.getCube(cubeName);
        this.cubeManager.updateCubeDropSegments(cube, (Collection)cube.getSegments());
    }

    private Boolean optimizeCube(String cubeName) throws Exception {
        CubeInstance cubeInstance = this.cubeManager.getCube(cubeName);
        Set<Long> cuboidsRecommend = this.mockRecommendCuboids(cubeInstance, 0.05, 255);
        CubeSegment[] optimizeSegments = this.cubeManager.optimizeSegments(cubeInstance, cuboidsRecommend);
        ArrayList optimizeJobList = Lists.newArrayListWithExpectedSize((int)optimizeSegments.length);
        for (CubeSegment optimizeSegment : optimizeSegments) {
            DefaultChainedExecutable optimizeJob = EngineFactory.createBatchOptimizeJob((CubeSegment)optimizeSegment, (String)"TEST");
            this.jobService.addJob((AbstractExecutable)optimizeJob);
            optimizeJobList.add(optimizeJob);
            optimizeSegment.setLastBuildJobID(optimizeJob.getId());
        }
        CheckpointExecutable checkpointJob = new BatchOptimizeJobCheckpointBuilder(cubeInstance, "TEST").build();
        checkpointJob.addTaskListForCheck((List)optimizeJobList);
        this.jobService.addJob((AbstractExecutable)checkpointJob);
        ExecutableState state = this.waitForJob(checkpointJob.getId());
        return ExecutableState.SUCCEED == state;
    }

    private Boolean mergeSegment(String cubeName, long startDate, long endDate) throws Exception {
        CubeSegment segment = this.cubeManager.mergeSegments(this.cubeManager.getCube(cubeName), new SegmentRange.TSRange(Long.valueOf(startDate), Long.valueOf(endDate)), null, true);
        DefaultChainedExecutable job = EngineFactory.createBatchMergeJob((CubeSegment)segment, (String)"TEST");
        this.jobService.addJob((AbstractExecutable)job);
        ExecutableState state = this.waitForJob(job.getId());
        return ExecutableState.SUCCEED == state;
    }

    private Boolean buildSegment(String cubeName, long startDate, long endDate) throws Exception {
        CubeInstance cubeInstance = this.cubeManager.getCube(cubeName);
        CubeSegment segment = this.cubeManager.appendSegment(cubeInstance, new SegmentRange.TSRange(Long.valueOf(0L), Long.valueOf(endDate)));
        DefaultChainedExecutable job = EngineFactory.createBatchCubingJob((CubeSegment)segment, (String)"TEST");
        this.jobService.addJob((AbstractExecutable)job);
        ExecutableState state = this.waitForJob(job.getId());
        return ExecutableState.SUCCEED == state;
    }

    private Set<Long> mockRecommendCuboids(CubeInstance cubeInstance, double maxRatio, int maxNumber) {
        HashSet cuboidsRecommend;
        Preconditions.checkArgument((maxRatio > 0.0 && maxRatio < 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxNumber > 0 ? 1 : 0) != 0);
        Random rnd = new Random();
        LinkedList mandatoryDimensionSetList = Lists.newLinkedList();
        mandatoryDimensionSetList.add(Sets.newHashSet((Object[])new String[]{"CAL_DT"}));
        mandatoryDimensionSetList.add(Sets.newHashSet((Object[])new String[]{"seller_id", "CAL_DT"}));
        mandatoryDimensionSetList.add(Sets.newHashSet((Object[])new String[]{"LSTG_FORMAT_NAME", "slr_segment_cd"}));
        Set mandatoryCuboids = cubeInstance.getDescriptor().generateMandatoryCuboids((List)mandatoryDimensionSetList);
        CuboidScheduler cuboidScheduler = cubeInstance.getCuboidScheduler();
        Set cuboidsCurrent = cuboidScheduler.getAllCuboidIds();
        long baseCuboid = cuboidScheduler.getBaseCuboidId();
        block0: do {
            cuboidsRecommend = Sets.newHashSet();
            cuboidsRecommend.add(baseCuboid);
            cuboidsRecommend.addAll(mandatoryCuboids);
            for (long i = 1L; i < baseCuboid; ++i) {
                if (rnd.nextDouble() < maxRatio) {
                    cuboidsRecommend.add(i);
                }
                if (cuboidsRecommend.size() > maxNumber) continue block0;
            }
        } while (cuboidsRecommend.equals(cuboidsCurrent));
        return cuboidsRecommend;
    }

    private int cleanupOldStorage() throws Exception {
        String[] args = new String[]{"--delete", "true"};
        StorageCleanupJob cli = new StorageCleanupJob();
        cli.execute(args);
        return 0;
    }

    private void checkHFilesInHBase(CubeSegment segment) throws IOException {
        try (Connection conn = HBaseConnection.get((StorageURL)KylinConfig.getInstanceFromEnv().getStorageUrl());){
            String tableName = segment.getStorageLocationIdentifier();
            HBaseRegionSizeCalculator cal = new HBaseRegionSizeCalculator(tableName, conn);
            Map sizeMap = cal.getRegionSizeMap();
            long totalSize = 0L;
            for (Long size : sizeMap.values()) {
                totalSize += size.longValue();
            }
            if (totalSize == 0L) {
                return;
            }
            Map countMap = cal.getRegionHFileCountMap();
            boolean hasMultiHFileRegions = false;
            for (Pair count : countMap.values()) {
                if ((Integer)count.getSecond() <= (Integer)count.getFirst()) continue;
                hasMultiHFileRegions = true;
                break;
            }
            if (KylinConfig.getInstanceFromEnv().getHBaseHFileSizeGB() == 0.0f && hasMultiHFileRegions) {
                throw new IOException("hfile size set to 0, but found region contains more than one hfiles");
            }
            if (KylinConfig.getInstanceFromEnv().getHBaseHFileSizeGB() > 0.0f && !hasMultiHFileRegions) {
                throw new IOException("hfile size set greater than 0, but all regions still has only one hfile");
            }
        }
    }

    private void checkEmptySegRangeInfo(CubeInstance cube) {
        CubeSegment segment = this.getLastModifiedSegment(cube);
        for (String colId : segment.getDimensionRangeInfoMap().keySet()) {
            DimensionRangeInfo range = (DimensionRangeInfo)segment.getDimensionRangeInfoMap().get(colId);
            if (range.getMax() == null && range.getMin() == null) continue;
            throw new RuntimeException("Empty segment must have null info.");
        }
    }

    private void checkNormalSegRangeInfo(CubeInstance cube) {
        CubeSegment segment = this.getLastModifiedSegment(cube);
        if (segment.getModel().getPartitionDesc().isPartitioned()) {
            TblColRef colRef = segment.getModel().getPartitionDesc().getPartitionDateColumnRef();
            DimensionRangeInfo dmRangeInfo = (DimensionRangeInfo)segment.getDimensionRangeInfoMap().get(colRef.getIdentity());
            long min_v = DateFormat.stringToMillis((String)dmRangeInfo.getMin());
            long max_v = DateFormat.stringToMillis((String)dmRangeInfo.getMax());
            long ts_range_start = (Long)segment.getTSRange().start.v;
            long ts_range_end = (Long)segment.getTSRange().end.v;
            if (ts_range_start > min_v || max_v > ts_range_end - 1L) {
                throw new RuntimeException(String.format(Locale.ROOT, "Build cube failed, wrong partition column min/max value. Segment: %s, min value: %s, TsRange.start: %s, max value: %s, TsRange.end: %s", segment, min_v, ts_range_start, max_v, ts_range_end));
            }
        }
    }

    private CubeSegment getLastModifiedSegment(CubeInstance cube) {
        return Collections.max(cube.getSegments(), new Comparator<CubeSegment>(){

            @Override
            public int compare(CubeSegment o1, CubeSegment o2) {
                return Long.compare(o1.getLastBuildTime(), o2.getLastBuildTime());
            }
        });
    }

    static {
        logger = LoggerFactory.getLogger(BuildCubeWithEngine.class);
    }

    private class TestCallable
    implements Callable<Boolean> {
        private final String methodName;
        private final CountDownLatch countDownLatch;

        public TestCallable(String methodName, CountDownLatch countDownLatch) {
            this.methodName = methodName;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public Boolean call() throws Exception {
            try {
                Method method = BuildCubeWithEngine.class.getDeclaredMethod(this.methodName, new Class[0]);
                method.setAccessible(true);
                Boolean bl = (Boolean)method.invoke((Object)BuildCubeWithEngine.this, new Object[0]);
                return bl;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw e;
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

