/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import com.google.common.collect.Lists;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.webapp.WebAppContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITJDBCDriverTest
extends HBaseMetadataTestCase {
    private static Server server = null;
    private static SystemPropertiesOverride sysPropsOverride = new SystemPropertiesOverride();
    private static final int PORT = new Random().nextInt(100) + 37070;
    private static final Logger logger = LoggerFactory.getLogger(ITJDBCDriverTest.class);

    @BeforeClass
    public static void beforeClass() throws Exception {
        logger.info("random jetty port: " + PORT);
        sysPropsOverride.override("spring.profiles.active", "testing");
        sysPropsOverride.override("catalina.home", ".");
        ITJDBCDriverTest.staticCreateTestMetadata();
        ITJDBCDriverTest.startJetty();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ITJDBCDriverTest.stopJetty();
        ITJDBCDriverTest.staticCleanupTestMetadata();
        sysPropsOverride.restore();
    }

    protected static void stopJetty() throws Exception {
        File workFolder;
        if (server != null) {
            server.stop();
        }
        if ((workFolder = new File("work")).isDirectory() && workFolder.exists()) {
            FileUtils.deleteDirectory((File)workFolder);
        }
    }

    protected static void startJetty() throws Exception {
        server = new Server(PORT);
        WebAppContext context = new WebAppContext();
        context.setDescriptor("../server/src/main/webapp/WEB-INF/web.xml");
        context.setResourceBase("../server/src/main/webapp");
        context.setContextPath("/kylin");
        context.setParentLoaderPriority(true);
        server.setHandler((Handler)context);
        server.start();
    }

    protected Connection getConnection() throws Exception {
        Driver driver = (Driver)Class.forName("org.apache.kylin.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Properties info = new Properties();
        info.put("user", "ADMIN");
        info.put("password", "KYLIN");
        Connection conn = driver.connect("jdbc:kylin://localhost:" + PORT + "/default", info);
        return conn;
    }

    @Test
    public void testMetadata1() throws Exception {
        String catalog;
        Connection conn = this.getConnection();
        ArrayList schemaList = Lists.newArrayList();
        DatabaseMetaData dbMetadata = conn.getMetaData();
        ResultSet resultSet = dbMetadata.getSchemas();
        while (resultSet.next()) {
            String schema = resultSet.getString("TABLE_SCHEM");
            catalog = resultSet.getString("TABLE_CATALOG");
            System.out.println("Get schema: schema=" + schema + ", catalog=" + catalog);
            schemaList.add(schema);
        }
        resultSet.close();
        Assert.assertTrue((boolean)schemaList.contains("DEFAULT"));
        Assert.assertTrue((boolean)schemaList.contains("EDW"));
        resultSet = dbMetadata.getCatalogs();
        ArrayList catalogList = Lists.newArrayList();
        while (resultSet.next()) {
            catalog = resultSet.getString("TABLE_CAT");
            System.out.println("Get catalog: catalog=" + catalog);
            catalogList.add(catalog);
        }
        resultSet.close();
        Assert.assertTrue((catalogList.size() > 0 && catalogList.contains("defaultCatalog") ? 1 : 0) != 0);
        conn.close();
    }

    @Test
    public void testMetadata2() throws Exception {
        String name;
        Connection conn = this.getConnection();
        ArrayList tableList = Lists.newArrayList();
        DatabaseMetaData dbMetadata = conn.getMetaData();
        ResultSet resultSet = dbMetadata.getTables(null, "%", "%", new String[]{"TABLE"});
        while (resultSet.next()) {
            String schema = resultSet.getString("TABLE_SCHEM");
            name = resultSet.getString("TABLE_NAME");
            System.out.println("Get table: schema=" + schema + ", name=" + name);
            tableList.add(schema + "." + name);
        }
        resultSet.close();
        Assert.assertTrue((boolean)tableList.contains("DEFAULT.TEST_KYLIN_FACT"));
        resultSet = dbMetadata.getColumns(null, "%", "TEST_KYLIN_FACT", "%");
        ArrayList columns = Lists.newArrayList();
        while (resultSet.next()) {
            name = resultSet.getString("COLUMN_NAME");
            String type = resultSet.getString("TYPE_NAME");
            System.out.println("Get column: name=" + name + ", data_type=" + type);
            columns.add(name);
        }
        Assert.assertTrue((columns.size() > 0 && columns.contains("CAL_DT") ? 1 : 0) != 0);
        resultSet.close();
        conn.close();
    }

    @Test
    public void testSimpleStatement() throws Exception {
        Connection conn = this.getConnection();
        Statement statement = conn.createStatement();
        statement.execute("select count(*) from test_kylin_fact");
        ResultSet rs = statement.getResultSet();
        Assert.assertTrue((boolean)rs.next());
        int result = rs.getInt(1);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
        rs.close();
        statement.close();
        conn.close();
    }

    @Test
    public void testPreparedStatement() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("select LSTG_FORMAT_NAME, sum(price) as GMV, count(1) as TRANS_CNT from test_kylin_fact where LSTG_FORMAT_NAME = ? group by LSTG_FORMAT_NAME");
        statement.setString(1, "FP-GTC");
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        String format_name = rs.getString(1);
        Assert.assertTrue((boolean)"FP-GTC".equals(format_name));
        rs.close();
        statement.close();
        conn.close();
    }

    @Test
    public void testResultSet() throws Exception {
        String sql = "select LSTG_FORMAT_NAME, sum(price) as GMV, count(1) as TRANS_CNT from test_kylin_fact \n group by LSTG_FORMAT_NAME ";
        Connection conn = this.getConnection();
        Statement statement = conn.createStatement();
        statement.execute(sql);
        ResultSet rs = statement.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            String lstg = rs.getString(1);
            double gmv = rs.getDouble(2);
            int trans_count = rs.getInt(3);
            System.out.println("Get a line: LSTG_FORMAT_NAME=" + lstg + ", GMV=" + gmv + ", TRANS_CNT=" + trans_count);
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
        statement.close();
        rs.close();
        conn.close();
    }

    @Test
    public void testResultSetWithMaxRows() throws Exception {
        String sql = "select LSTG_FORMAT_NAME, sum(price) as GMV, count(1) as TRANS_CNT from test_kylin_fact \n group by LSTG_FORMAT_NAME ";
        Connection conn = this.getConnection();
        Statement statement = conn.createStatement();
        statement.setMaxRows(2);
        statement.execute(sql);
        ResultSet rs = statement.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            String lstg = rs.getString(1);
            double gmv = rs.getDouble(2);
            int trans_count = rs.getInt(3);
            System.out.println("Get a line: LSTG_FORMAT_NAME=" + lstg + ", GMV=" + gmv + ", TRANS_CNT=" + trans_count);
        }
        Assert.assertTrue((count == 2 ? 1 : 0) != 0);
        statement.close();
        rs.close();
        conn.close();
    }

    @Test
    public void testPreparedStatementWithCache() throws Exception {
        Connection conn = this.getConnection();
        PreparedStatement statement = conn.prepareStatement("select count(1) as TRANS_CNT from test_kylin_fact where LSTG_FORMAT_NAME like ?");
        statement.setString(1, "%");
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Object object = rs.getObject(1);
        long countFirst = (Long)object;
        statement.setString(1, "O%");
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        object = rs.getObject(1);
        long countSecond = (Long)object;
        Assert.assertTrue((countFirst > countSecond ? 1 : 0) != 0);
        rs.close();
        statement.close();
        conn.close();
    }

    private static class SystemPropertiesOverride {
        HashMap<String, String> backup = new HashMap();

        private SystemPropertiesOverride() {
        }

        public void override(String key, String value) {
            this.backup.put(key, System.getProperty(key));
            System.setProperty(key, value);
        }

        public void restore() {
            for (String key : this.backup.keySet()) {
                String value = this.backup.get(key);
                if (value == null) {
                    System.clearProperty(key);
                    continue;
                }
                System.setProperty(key, value);
            }
            this.backup.clear();
        }
    }
}

