/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.GlobalDictionaryBuilder;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ITGlobalDictionaryBuilderTest
extends HBaseMetadataTestCase {
    private DictionaryInfo dictionaryInfo;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void beforeTest() throws Exception {
        ITGlobalDictionaryBuilderTest.staticCreateTestMetadata();
        this.dictionaryInfo = new DictionaryInfo("testTable", "testColumn", 0, "String", null);
    }

    @After
    public void afterTest() {
        this.cleanup();
        ITGlobalDictionaryBuilderTest.staticCleanupTestMetadata();
    }

    private void cleanup() {
        String BASE_DIR = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "/resources/GlobalDict" + this.dictionaryInfo.getResourceDir() + "/";
        Path basePath = new Path(BASE_DIR);
        try {
            HadoopUtil.getFileSystem((Path)basePath).delete(basePath, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalDictLock() throws IOException, InterruptedException {
        int i;
        CountDownLatch startLatch = new CountDownLatch(3);
        CountDownLatch finishLatch = new CountDownLatch(3);
        SharedBuilderThread t1 = new SharedBuilderThread(startLatch, finishLatch, "t1_", 10000);
        SharedBuilderThread t2 = new SharedBuilderThread(startLatch, finishLatch, "t2_", 10);
        SharedBuilderThread t3 = new SharedBuilderThread(startLatch, finishLatch, "t3_", 100000);
        t1.start();
        t2.start();
        t3.start();
        startLatch.await();
        finishLatch.await();
        GlobalDictionaryBuilder builder = new GlobalDictionaryBuilder();
        builder.init(this.dictionaryInfo, 0, KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
        builder.addValue("success");
        Dictionary dict = builder.build();
        for (i = 0; i < 10000; ++i) {
            Assert.assertNotEquals((long)-1L, (long)dict.getIdFromValue((Object)("t1_" + i)));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertNotEquals((long)-1L, (long)dict.getIdFromValue((Object)("t2_" + i)));
        }
        for (i = 0; i < 100000; ++i) {
            Assert.assertNotEquals((long)-1L, (long)dict.getIdFromValue((Object)("t3_" + i)));
        }
        Assert.assertEquals((long)110011L, (long)dict.getIdFromValue((Object)"success"));
    }

    @Test
    public void testBuildGlobalDictFailed() throws IOException {
        this.thrown.expect(IOException.class);
        this.thrown.expectMessage("read failed.");
        GlobalDictionaryBuilder builder = new GlobalDictionaryBuilder();
        try {
            DictionaryGenerator.buildDictionary((IDictionaryBuilder)builder, (DictionaryInfo)this.dictionaryInfo, (IDictionaryValueEnumerator)new ErrorDictionaryValueEnumerator());
        }
        catch (Throwable e) {
            DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
            String lockPath = "/dict/" + this.dictionaryInfo.getSourceTable() + "_" + this.dictionaryInfo.getSourceColumn() + "/lock";
            Assert.assertFalse((boolean)lock.isLocked(lockPath));
            throw e;
        }
    }

    private class ErrorDictionaryValueEnumerator
    implements IDictionaryValueEnumerator {
        private int idx = 0;

        private ErrorDictionaryValueEnumerator() {
        }

        public String current() throws IOException {
            return null;
        }

        public boolean moveNext() throws IOException {
            ++this.idx;
            if (this.idx == 1) {
                throw new IOException("read failed.");
            }
            return true;
        }

        public void close() throws IOException {
        }
    }

    private class SharedBuilderThread
    extends Thread {
        CountDownLatch startLatch;
        CountDownLatch finishLatch;
        String prefix;
        int count;

        SharedBuilderThread(CountDownLatch startLatch, CountDownLatch finishLatch, String prefix, int count) {
            this.startLatch = startLatch;
            this.finishLatch = finishLatch;
            this.prefix = prefix;
            this.count = count;
        }

        @Override
        public void run() {
            try {
                GlobalDictionaryBuilder builder = new GlobalDictionaryBuilder();
                this.startLatch.countDown();
                builder.init(ITGlobalDictionaryBuilderTest.this.dictionaryInfo, 0, KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory());
                for (int i = 0; i < this.count; ++i) {
                    builder.addValue(this.prefix + i);
                }
                builder.build();
                this.finishLatch.countDown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

