/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.InMemCubeBuilder;
import org.apache.kylin.cube.inmemcubing.InputConverterUnitForRawData;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.dict.IterableDictionaryValueEnumerator;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITInMemCubeBuilderTest
extends LocalFileMetadataTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ITInMemCubeBuilderTest.class);
    private CubeInstance cube;
    private String flatTable;
    private Map<TblColRef, Dictionary<String>> dictionaryMap;
    private int nInpRows;
    private int nThreads;

    @Before
    public void before() throws IOException {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testSSBCubeMore() throws Exception {
        this.testBuild("ssb", "../examples/test_case_data/localmeta/data/kylin_intermediate_ssb_19920101000000_19920201000000.csv", 7000, 4);
    }

    @Test
    public void testSSBCube() throws Exception {
        this.testBuild("ssb", "../examples/test_case_data/localmeta/data/kylin_intermediate_ssb_19920101000000_19920201000000.csv", 1000, 1);
    }

    public void testBuild(String cubeName, String flatTable, int nInpRows, int nThreads) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        this.nInpRows = nInpRows;
        this.nThreads = nThreads;
        this.cube = cubeManager.getCube(cubeName);
        this.flatTable = flatTable;
        this.dictionaryMap = ITInMemCubeBuilderTest.getDictionaryMap(this.cube, flatTable);
        this.testBuildInner();
    }

    private void testBuildInner() throws Exception {
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeDesc)this.cube.getDescriptor());
        InMemCubeBuilder cubeBuilder = new InMemCubeBuilder(this.cube.getCuboidScheduler(), flatDesc, this.dictionaryMap);
        cubeBuilder.setConcurrentThreads(this.nThreads);
        ArrayBlockingQueue<String[]> queue = new ArrayBlockingQueue<String[]>(1000);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executorService.submit(cubeBuilder.buildAsRunnable(queue, (ICuboidWriter)new ConsoleGTRecordWriter()));
            ITInMemCubeBuilderTest.feedData(this.cube, this.flatTable, queue, this.nInpRows);
            future.get();
            future = executorService.submit(cubeBuilder.buildAsRunnable(queue, (ICuboidWriter)new ConsoleGTRecordWriter()));
            ITInMemCubeBuilderTest.feedData(this.cube, this.flatTable, queue, 0);
            future.get();
            future = executorService.submit(cubeBuilder.buildAsRunnable(queue, (ICuboidWriter)new ConsoleGTRecordWriter()));
            ITInMemCubeBuilderTest.feedData(this.cube, this.flatTable, queue, this.nInpRows);
            future.get();
        }
        catch (Exception e) {
            logger.error("stream build failed", (Throwable)e);
            throw new IOException("Failed to build cube ", e);
        }
    }

    static void feedData(CubeInstance cube, String flatTable, ArrayBlockingQueue<String[]> queue, int count) throws IOException, InterruptedException {
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, count, 0L);
    }

    static void feedData(CubeInstance cube, String flatTable, ArrayBlockingQueue<String[]> queue, int count, long randSeed) throws IOException, InterruptedException {
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, count, randSeed, Integer.MAX_VALUE);
    }

    static void feedData(CubeInstance cube, String flatTable, ArrayBlockingQueue<String[]> queue, int count, long randSeed, int splitRowThreshold) throws IOException, InterruptedException {
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeDesc)cube.getDescriptor());
        int nColumns = flatDesc.getAllColumns().size();
        Set[] distinctSets = new Set[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            distinctSets[i] = new TreeSet();
        }
        List lines = FileUtils.readLines((File)new File(flatTable), (String)"UTF-8");
        for (String line : lines) {
            String[] row = StringUtil.splitByComma((String)line.trim());
            assert (row.length == nColumns);
            for (int i = 0; i < nColumns; ++i) {
                distinctSets[i].add(row[i]);
            }
        }
        ArrayList<String[]> distincts = new ArrayList<String[]>();
        for (int i = 0; i < nColumns; ++i) {
            distincts.add(distinctSets[i].toArray(new String[distinctSets[i].size()]));
        }
        Random rand = new Random();
        if (randSeed != 0L) {
            rand.setSeed(randSeed);
        }
        int countOfLastSplit = 0;
        while (count > 0) {
            String[] row = new String[nColumns];
            for (int i = 0; i < nColumns; ++i) {
                String[] candidates = (String[])distincts.get(i);
                row[i] = candidates[rand.nextInt(candidates.length)];
            }
            queue.put(row);
            if (++countOfLastSplit >= splitRowThreshold) {
                queue.put(InputConverterUnitForRawData.CUT_ROW);
                countOfLastSplit = 0;
            }
            --count;
        }
        queue.put(InputConverterUnitForRawData.END_ROW);
    }

    static Map<TblColRef, Dictionary<String>> getDictionaryMap(CubeInstance cube, String flatTable) throws IOException {
        HashMap result = Maps.newHashMap();
        CubeDesc desc = cube.getDescriptor();
        CubeJoinedFlatTableEnrich flatDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc((CubeDesc)desc), desc);
        int nColumns = flatDesc.getAllColumns().size();
        List columns = Cuboid.getBaseCuboid((CubeDesc)desc).getColumns();
        for (int c = 0; c < columns.size(); ++c) {
            TblColRef col = (TblColRef)columns.get(c);
            if (!desc.getRowkey().isUseDictionary(col)) continue;
            logger.info("Building dictionary for " + col);
            List<String> valueList = ITInMemCubeBuilderTest.readValueList(flatTable, nColumns, flatDesc.getRowKeyColumnIndexes()[c]);
            Dictionary dict = DictionaryGenerator.buildDictionary((DataType)col.getType(), (IDictionaryValueEnumerator)new IterableDictionaryValueEnumerator(valueList));
            result.put(col, dict);
        }
        for (int measureIdx = 0; measureIdx < cube.getDescriptor().getMeasures().size(); ++measureIdx) {
            MeasureDesc measureDesc = (MeasureDesc)cube.getDescriptor().getMeasures().get(measureIdx);
            FunctionDesc func = measureDesc.getFunction();
            List dictCols = func.getMeasureType().getColumnsNeedDictionary(func);
            if (dictCols.isEmpty()) continue;
            int[] flatTableIdx = flatDesc.getMeasureColumnIndexes()[measureIdx];
            List paramCols = func.getParameter().getColRefs();
            for (int i = 0; i < paramCols.size(); ++i) {
                TblColRef col = (TblColRef)paramCols.get(i);
                if (!dictCols.contains(col)) continue;
                int colIdxOnFlat = flatTableIdx[i];
                logger.info("Building dictionary for " + col);
                List<String> valueList = ITInMemCubeBuilderTest.readValueList(flatTable, nColumns, colIdxOnFlat);
                Dictionary dict = DictionaryGenerator.buildDictionary((DataType)col.getType(), (IDictionaryValueEnumerator)new IterableDictionaryValueEnumerator(valueList));
                result.put(col, dict);
            }
        }
        return result;
    }

    private static List<String> readValueList(String flatTable, int nColumns, int c) throws IOException {
        ArrayList result = Lists.newArrayList();
        List lines = FileUtils.readLines((File)new File(flatTable), (String)"UTF-8");
        for (String line : lines) {
            String[] row = StringUtil.splitByComma((String)line.trim());
            if (row.length != nColumns) {
                throw new IllegalStateException();
            }
            if (row[c] == null) continue;
            result.add(row[c]);
        }
        return result;
    }

    class ConsoleGTRecordWriter
    implements ICuboidWriter {
        boolean verbose = false;

        ConsoleGTRecordWriter() {
        }

        public void write(long cuboidId, GTRecord record) throws IOException {
            if (this.verbose) {
                System.out.println(record.toString());
            }
        }

        public void write(long cuboidId, GridTable table) throws IOException {
            if (this.verbose) {
                System.out.println(table.toString());
            }
        }

        public void flush() {
            if (this.verbose) {
                System.out.println("flush");
            }
        }

        public void close() {
            if (this.verbose) {
                System.out.println("close");
            }
        }
    }
}

