/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.inmemcubing.DoggedCubeBuilder;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.ITInMemCubeBuilderTest;
import org.apache.kylin.cube.inmemcubing.InMemCubeBuilder;
import org.apache.kylin.cube.inmemcubing2.DoggedCubeBuilder2;
import org.apache.kylin.cube.inmemcubing2.InMemCubeBuilder2;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITDoggedCubeBuilderTest
extends LocalFileMetadataTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ITDoggedCubeBuilderTest.class);
    private static final int INPUT_ROWS = 10000;
    private static final int SPLIT_ROWS = 2000;
    private static final int THREADS = 4;
    private static CubeInstance cube;
    private static String flatTable;
    private static Map<TblColRef, Dictionary<String>> dictionaryMap;

    @BeforeClass
    public static void before() throws IOException {
        ITDoggedCubeBuilderTest.staticCreateTestMetadata((String[])new String[0]);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        cube = cubeManager.getCube("ssb");
        flatTable = "../examples/test_case_data/localmeta/data/kylin_intermediate_ssb_19920101000000_19920201000000.csv";
        dictionaryMap = ITInMemCubeBuilderTest.getDictionaryMap(cube, flatTable);
    }

    @AfterClass
    public static void after() throws Exception {
        ITDoggedCubeBuilderTest.cleanAfterClass();
    }

    @Test
    public void test() throws Exception {
        ArrayBlockingQueue<String[]> queue = new ArrayBlockingQueue<String[]>(1000);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        long randSeed = System.currentTimeMillis();
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeDesc)cube.getDescriptor());
        InMemCubeBuilder inmemBuilder = new InMemCubeBuilder(cube.getCuboidScheduler(), flatDesc, dictionaryMap);
        inmemBuilder.setConcurrentThreads(4);
        FileRecordWriter inmemResult = new FileRecordWriter();
        Future<?> future = executorService.submit(inmemBuilder.buildAsRunnable(queue, (ICuboidWriter)inmemResult));
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, 10000, randSeed);
        future.get();
        inmemResult.close();
        DoggedCubeBuilder doggedBuilder = new DoggedCubeBuilder(cube.getCuboidScheduler(), flatDesc, dictionaryMap);
        doggedBuilder.setConcurrentThreads(4);
        FileRecordWriter doggedResult = new FileRecordWriter();
        Future<?> future2 = executorService.submit(doggedBuilder.buildAsRunnable(queue, (ICuboidWriter)doggedResult));
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, 10000, randSeed, 2000);
        future2.get();
        doggedResult.close();
        InMemCubeBuilder2 inmemBuilder2 = new InMemCubeBuilder2(cube.getCuboidScheduler(), flatDesc, dictionaryMap);
        inmemBuilder2.setConcurrentThreads(4);
        FileRecordWriter inmemResult2 = new FileRecordWriter();
        Future<?> future3 = executorService.submit(inmemBuilder2.buildAsRunnable(queue, (ICuboidWriter)inmemResult2));
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, 10000, randSeed);
        future3.get();
        inmemResult2.close();
        DoggedCubeBuilder2 doggedBuilder2 = new DoggedCubeBuilder2(cube.getCuboidScheduler(), flatDesc, dictionaryMap);
        doggedBuilder2.setConcurrentThreads(4);
        FileRecordWriter doggedResult2 = new FileRecordWriter();
        Future<?> future4 = executorService.submit(doggedBuilder2.buildAsRunnable(queue, (ICuboidWriter)doggedResult2));
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, 10000, randSeed, 2000);
        future4.get();
        doggedResult2.close();
        this.fileCompare(inmemResult.file, inmemResult2.file);
        this.fileCompare(inmemResult.file, doggedResult.file);
        this.fileCompare2(inmemResult.file, doggedResult2.file);
        inmemResult.file.delete();
        inmemResult2.file.delete();
        doggedResult.file.delete();
        doggedResult2.file.delete();
    }

    private void fileCompare(File file, File file2) throws IOException {
        String line2;
        String line1;
        BufferedReader r1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        BufferedReader r2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
        do {
            line1 = r1.readLine();
            line2 = r2.readLine();
            Assert.assertEquals((Object)line1, (Object)line2);
        } while (line1 != null || line2 != null);
        r1.close();
        r2.close();
    }

    private void fileCompare2(File file, File file2) throws IOException {
        Map<String, Integer> content1 = this.readContents(file);
        Map<String, Integer> content2 = this.readContents(file2);
        Assert.assertEquals(content1, content2);
    }

    private Map<String, Integer> readContents(File file) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        HashMap content = Maps.newHashMap();
        while ((line = r.readLine()) != null) {
            Integer cnt = (Integer)content.get(line);
            if (cnt == null) {
                cnt = 0;
            }
            content.put(line, cnt + 1);
        }
        r.close();
        return content;
    }

    class FileRecordWriter
    implements ICuboidWriter {
        File file = File.createTempFile("DoggedCubeBuilderTest_", ".data");
        PrintWriter writer = new PrintWriter(this.file, "UTF-8");

        FileRecordWriter() throws IOException {
        }

        public void write(long cuboidId, GTRecord record) throws IOException {
            this.writer.print(cuboidId);
            this.writer.print(", ");
            this.writer.print(record.toString());
            this.writer.println();
        }

        public void write(long cuboidId, GridTable table) throws IOException {
            this.writer.print(cuboidId);
            this.writer.print(", ");
            this.writer.print(table.toString());
            this.writer.println();
        }

        public void flush() {
        }

        public void close() {
            this.writer.close();
        }
    }
}

