/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.inmemcubing.DoggedCubeBuilder;
import org.apache.kylin.cube.inmemcubing.ICuboidWriter;
import org.apache.kylin.cube.inmemcubing.ITInMemCubeBuilderTest;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="to save CI time")
public class ITDoggedCubeBuilderStressTest
extends LocalFileMetadataTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ITDoggedCubeBuilderStressTest.class);
    private static final int INPUT_ROWS = 200000;
    private static final int THREADS = 4;
    private static CubeInstance cube;
    private static String flatTable;
    private static Map<TblColRef, Dictionary<String>> dictionaryMap;

    @BeforeClass
    public static void before() throws IOException {
        ITDoggedCubeBuilderStressTest.staticCreateTestMetadata((String[])new String[0]);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)kylinConfig);
        cube = cubeManager.getCube("ssb");
        flatTable = "../examples/test_case_data/localmeta/data/kylin_intermediate_ssb_19920101000000_19920201000000.csv";
        dictionaryMap = ITInMemCubeBuilderTest.getDictionaryMap(cube, flatTable);
    }

    @AfterClass
    public static void after() throws Exception {
        ITDoggedCubeBuilderStressTest.cleanAfterClass();
    }

    @Test
    public void test() throws Exception {
        ArrayBlockingQueue<String[]> queue = new ArrayBlockingQueue<String[]>(1000);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        long randSeed = System.currentTimeMillis();
        IJoinedFlatTableDesc flatDesc = EngineFactory.getJoinedFlatTableDesc((CubeDesc)cube.getDescriptor());
        DoggedCubeBuilder doggedBuilder = new DoggedCubeBuilder(cube.getCuboidScheduler(), flatDesc, dictionaryMap);
        doggedBuilder.setConcurrentThreads(4);
        Future<?> future = executorService.submit(doggedBuilder.buildAsRunnable(queue, (ICuboidWriter)new NoopWriter()));
        ITInMemCubeBuilderTest.feedData(cube, flatTable, queue, 200000, randSeed);
        future.get();
    }

    class NoopWriter
    implements ICuboidWriter {
        NoopWriter() {
        }

        public void write(long cuboidId, GTRecord record) throws IOException {
        }

        public void write(long cuboidId, GridTable table) throws IOException {
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

