/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import java.util.List;
import org.apache.kylin.cube.cuboid.algorithm.BPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.ITAlgorithmTestBase;
import org.apache.kylin.cube.cuboid.algorithm.PBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.SPBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.greedy.GreedyAlgorithm;
import org.junit.Test;

public class ITGreedyAlgorithmTest
extends ITAlgorithmTestBase {
    @Test
    public void testBPUSCalculator() {
        BPUSCalculator benefitPolicy = new BPUSCalculator(this.cuboidStats);
        GreedyAlgorithm algorithm = new GreedyAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by BPUSCalculator: " + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }

    @Test
    public void testPBPUSCalculator() {
        PBPUSCalculator benefitPolicy = new PBPUSCalculator(this.cuboidStats);
        GreedyAlgorithm algorithm = new GreedyAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by PBPUSCalculator:" + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }

    @Test
    public void testSPBPUSCalculator() {
        SPBPUSCalculator benefitPolicy = new SPBPUSCalculator(this.cuboidStats);
        GreedyAlgorithm algorithm = new GreedyAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by SPBPUSCalculator:" + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }
}

