/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.BPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.ITAlgorithmTestBase;
import org.apache.kylin.cube.cuboid.algorithm.PBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.SPBPUSCalculator;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosomeHelper;
import org.apache.kylin.cube.cuboid.algorithm.generic.GeneticAlgorithm;
import org.junit.Assert;
import org.junit.Test;

public class ITGeneticAlgorithmTest
extends ITAlgorithmTestBase {
    @Test
    public void testChromosomeIsSame() {
        BPUSCalculator benefitPolicy = new BPUSCalculator(this.cuboidStats);
        double maxSpaceLimit = this.cuboidStats.getBaseCuboidSize() * 10.0;
        BitsChromosomeHelper helper = new BitsChromosomeHelper(maxSpaceLimit, this.cuboidStats);
        double maxSpaceLimit1 = this.cuboidStats.getBaseCuboidSize() * 12.0;
        BitsChromosomeHelper helper1 = new BitsChromosomeHelper(maxSpaceLimit1, this.cuboidStats);
        BitSet representation = new BitSet();
        representation.set(10);
        BitsChromosome chromosome = new BitsChromosome(representation, (BenefitPolicy)benefitPolicy, helper);
        HashSet chromosomeSet = Sets.newHashSet((Object[])new Chromosome[]{chromosome});
        BitSet representation1 = new BitSet();
        representation1.set(10);
        chromosomeSet.add(chromosome.newBitsChromosome(representation1));
        Assert.assertEquals((long)1L, (long)chromosomeSet.size());
        BitSet representation2 = new BitSet();
        representation2.set(12);
        chromosomeSet.add(chromosome.newBitsChromosome(representation2));
        Assert.assertEquals((long)2L, (long)chromosomeSet.size());
        BitSet representation3 = new BitSet();
        representation3.set(12);
        chromosomeSet.add(new BitsChromosome(representation3, (BenefitPolicy)benefitPolicy, helper1));
        Assert.assertEquals((long)2L, (long)chromosomeSet.size());
    }

    @Test
    public void testBPUSCalculator() {
        BPUSCalculator benefitPolicy = new BPUSCalculator(this.cuboidStats);
        GeneticAlgorithm algorithm = new GeneticAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by BPUSCalculator: " + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }

    @Test
    public void testPBPUSCalculator() {
        PBPUSCalculator benefitPolicy = new PBPUSCalculator(this.cuboidStats);
        GeneticAlgorithm algorithm = new GeneticAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by PBPUSCalculator:" + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }

    @Test
    public void testSPBPUSCalculator() {
        SPBPUSCalculator benefitPolicy = new SPBPUSCalculator(this.cuboidStats);
        GeneticAlgorithm algorithm = new GeneticAlgorithm(-1L, (BenefitPolicy)benefitPolicy, this.cuboidStats);
        List recommendList = algorithm.recommend(10.0);
        System.out.println("recommendList by SPBPUSCalculator:" + recommendList);
        System.out.println("Cost evaluated for each query: " + this.getQueryCostRatio(this.cuboidStats, recommendList));
    }
}

