/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.cuboid.TreeCuboidScheduler;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.junit.After;
import org.junit.Before;

public class ITAlgorithmTestBase {
    public CuboidStats cuboidStats;
    private Set<Long> mandatoryCuboids;

    @Before
    public void setUp() throws Exception {
        this.mandatoryCuboids = Sets.newHashSet();
        this.mandatoryCuboids.add(3000L);
        this.mandatoryCuboids.add(1888L);
        this.mandatoryCuboids.add(88L);
        this.cuboidStats = new CuboidStats.Builder("test", Long.valueOf(4095L), this.simulateCount(), this.simulateSpaceSize()).setMandatoryCuboids(this.mandatoryCuboids).setHitFrequencyMap(this.simulateHitFrequency()).setScanCountSourceMap(this.simulateScanCount()).build();
    }

    @After
    public void after() throws Exception {
    }

    public double getQueryCostRatio(CuboidStats cuboidStats, List<Long> recommendList) {
        TreeCuboidScheduler.CuboidTree cuboidTree = TreeCuboidScheduler.CuboidTree.createFromCuboids(recommendList, (Comparator)new TreeCuboidScheduler.CuboidCostComparator(cuboidStats.getStatistics()));
        double queryCostBest = 0.0;
        for (Long cuboidId : cuboidStats.getAllCuboidsForSelection()) {
            if (cuboidStats.getCuboidQueryCost(cuboidId.longValue()) == null) continue;
            queryCostBest += cuboidStats.getCuboidHitProbability(cuboidId.longValue()) * (double)cuboidStats.getCuboidCount(cuboidId.longValue()).longValue();
        }
        double queryCost = 0.0;
        for (Long cuboidId : cuboidStats.getAllCuboidsForSelection()) {
            long matchCuboidId = cuboidTree.findBestMatchCuboid(cuboidId.longValue());
            if (cuboidStats.getCuboidQueryCost(matchCuboidId) == null) continue;
            queryCost += cuboidStats.getCuboidHitProbability(cuboidId.longValue()) * (double)cuboidStats.getCuboidCount(matchCuboidId).longValue();
        }
        return queryCostBest / queryCost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, Long> simulateCount() {
        HashMap countMap = Maps.newHashMap();
        BufferedReader br = null;
        try {
            String sCurrentLine;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("src/test/resources/statistics.txt"), StandardCharsets.UTF_8));
            while ((sCurrentLine = br.readLine()) != null) {
                String[] statPair = StringUtil.split((String)sCurrentLine, (String)" ");
                countMap.put(Long.valueOf(statPair[0]), Long.valueOf(statPair[1]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return countMap;
    }

    protected Map<Long, Double> simulateSpaceSize() {
        HashMap sizeMap = Maps.newHashMap();
        Map<Long, Long> countMap = this.simulateCount();
        for (Map.Entry<Long, Long> entry : countMap.entrySet()) {
            sizeMap.put(entry.getKey(), (double)entry.getValue().longValue() * 1.0);
        }
        return sizeMap;
    }

    protected Map<Long, Long> simulateHitFrequency() {
        HashMap hitFrequencyMap = Maps.newHashMap();
        hitFrequencyMap.put(4095L, 10L);
        hitFrequencyMap.put(3849L, 15L);
        hitFrequencyMap.put(3780L, 31L);
        hitFrequencyMap.put(3459L, 16L);
        hitFrequencyMap.put(3145L, 29L);
        hitFrequencyMap.put(2861L, 21L);
        hitFrequencyMap.put(2768L, 40L);
        hitFrequencyMap.put(1528L, 10L);
        hitFrequencyMap.put(1440L, 9L);
        hitFrequencyMap.put(1152L, 21L);
        hitFrequencyMap.put(256L, 23L);
        hitFrequencyMap.put(128L, 7L);
        hitFrequencyMap.put(272L, 8L);
        hitFrequencyMap.put(288L, 10L);
        hitFrequencyMap.put(384L, 2L);
        hitFrequencyMap.put(320L, 3L);
        hitFrequencyMap.put(432L, 5L);
        hitFrequencyMap.put(258L, 8L);
        hitFrequencyMap.put(336L, 10L);
        hitFrequencyMap.put(274L, 22L);
        hitFrequencyMap.put(488L, 41L);
        hitFrequencyMap.put(352L, 10L);
        hitFrequencyMap.put(16L, 1L);
        hitFrequencyMap.put(32L, 5L);
        hitFrequencyMap.put(34L, 1L);
        hitFrequencyMap.put(2L, 21L);
        return hitFrequencyMap;
    }

    protected Map<Long, Map<Long, Long>> simulateScanCount() {
        LinkedHashMap scanCountMap = Maps.newLinkedHashMap();
        scanCountMap.put(4094L, new HashMap<Long, Long>(){
            {
                this.put(4095L, 1833041L);
            }
        });
        scanCountMap.put(3849L, new HashMap<Long, Long>(){
            {
                this.put(3849L, 276711L);
            }
        });
        scanCountMap.put(3780L, new HashMap<Long, Long>(){
            {
                this.put(3780L, 129199L);
            }
        });
        scanCountMap.put(3459L, new HashMap<Long, Long>(){
            {
                this.put(3459L, 168109L);
            }
        });
        scanCountMap.put(3145L, new HashMap<Long, Long>(){
            {
                this.put(3145L, 299991L);
            }
        });
        scanCountMap.put(2861L, new HashMap<Long, Long>(){
            {
                this.put(2861L, 2121L);
            }
        });
        scanCountMap.put(2768L, new HashMap<Long, Long>(){
            {
                this.put(2768L, 40231L);
            }
        });
        scanCountMap.put(256L, new HashMap<Long, Long>(){
            {
                this.put(256L, 1L);
            }
        });
        scanCountMap.put(16L, new HashMap<Long, Long>(){
            {
                this.put(16L, 1L);
            }
        });
        scanCountMap.put(32L, new HashMap<Long, Long>(){
            {
                this.put(32L, 2L);
            }
        });
        scanCountMap.put(128L, new HashMap<Long, Long>(){
            {
                this.put(128L, 3L);
            }
        });
        scanCountMap.put(272L, new HashMap<Long, Long>(){
            {
                this.put(272L, 2L);
            }
        });
        scanCountMap.put(288L, new HashMap<Long, Long>(){
            {
                this.put(288L, 3L);
            }
        });
        scanCountMap.put(2L, new HashMap<Long, Long>(){
            {
                this.put(2L, 1L);
            }
        });
        scanCountMap.put(384L, new HashMap<Long, Long>(){
            {
                this.put(384L, 2L);
            }
        });
        scanCountMap.put(320L, new HashMap<Long, Long>(){
            {
                this.put(320L, 3L);
            }
        });
        scanCountMap.put(432L, new HashMap<Long, Long>(){
            {
                this.put(432L, 5L);
            }
        });
        scanCountMap.put(1152L, new HashMap<Long, Long>(){
            {
                this.put(1152L, 21L);
            }
        });
        scanCountMap.put(258L, new HashMap<Long, Long>(){
            {
                this.put(258L, 2L);
            }
        });
        scanCountMap.put(1440L, new HashMap<Long, Long>(){
            {
                this.put(1440L, 9L);
            }
        });
        scanCountMap.put(336L, new HashMap<Long, Long>(){
            {
                this.put(336L, 2L);
            }
        });
        scanCountMap.put(336L, new HashMap<Long, Long>(){
            {
                this.put(336L, 2L);
            }
        });
        scanCountMap.put(274L, new HashMap<Long, Long>(){
            {
                this.put(274L, 1L);
            }
        });
        scanCountMap.put(488L, new HashMap<Long, Long>(){
            {
                this.put(488L, 16L);
            }
        });
        scanCountMap.put(352L, new HashMap<Long, Long>(){
            {
                this.put(352L, 3L);
            }
        });
        scanCountMap.put(1528L, new HashMap<Long, Long>(){
            {
                this.put(1528L, 21L);
            }
        });
        scanCountMap.put(34L, new HashMap<Long, Long>(){
            {
                this.put(34L, 1L);
            }
        });
        return scanCountMap;
    }
}

