/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.engine.mr.DFSFileTable;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.IReadableTable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ITDictionaryManagerTest
extends LocalFileMetadataTestCase {
    DictionaryManager dictMgr;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void basic() throws Exception {
        this.dictMgr = DictionaryManager.getInstance((KylinConfig)ITDictionaryManagerTest.getTestConfig());
        CubeDesc cubeDesc = CubeDescManager.getInstance((KylinConfig)ITDictionaryManagerTest.getTestConfig()).getCubeDesc("test_kylin_cube_without_slr_desc");
        TblColRef col = cubeDesc.findColumnRef("DEFAULT.TEST_KYLIN_FACT", "LSTG_FORMAT_NAME");
        MockDistinctColumnValuesProvider mockupData = new MockDistinctColumnValuesProvider("A", "B", "C");
        DictionaryInfo info1 = this.dictMgr.buildDictionary(col, mockupData.getDistinctValuesFor(col));
        System.out.println(JsonUtil.writeValueAsIndentString((Object)info1));
        DictionaryInfo info2 = this.dictMgr.buildDictionary(col, mockupData.getDistinctValuesFor(col));
        System.out.println(JsonUtil.writeValueAsIndentString((Object)info2));
        Assert.assertTrue((info1.getUuid() == info2.getUuid() ? 1 : 0) != 0);
        Assert.assertTrue((info1 == this.dictMgr.getDictionaryInfo(info1.getResourcePath()) ? 1 : 0) != 0);
        Assert.assertTrue((info2 == this.dictMgr.getDictionaryInfo(info2.getResourcePath()) ? 1 : 0) != 0);
        Assert.assertTrue((info1.getDictionaryObject() == info2.getDictionaryObject() ? 1 : 0) != 0);
        Dictionary dict = info1.getDictionaryObject();
        int id = 0;
        for (String v : mockupData.set) {
            Assert.assertEquals((long)id, (long)dict.getIdFromValue((Object)v, 0));
            Assert.assertEquals((Object)v, (Object)dict.getValueFromId(id));
            ++id;
        }
        MockDistinctColumnValuesProvider mockupEmpty = new MockDistinctColumnValuesProvider(new String[0]);
        DictionaryInfo info3 = this.dictMgr.buildDictionary(col, mockupEmpty.getDistinctValuesFor(col));
        System.out.println(JsonUtil.writeValueAsIndentString((Object)info3));
        Assert.assertEquals((long)0L, (long)info3.getCardinality());
        Assert.assertEquals((long)0L, (long)info3.getDictionaryObject().getSize());
        System.out.println(info3.getDictionaryObject().getMaxId());
        System.out.println(info3.getDictionaryObject().getMinId());
        System.out.println(info3.getDictionaryObject().getSizeOfId());
    }

    private static class MockDistinctColumnValuesProvider
    implements DistinctColumnValuesProvider {
        String tmpFilePath;
        Set<String> set;

        public MockDistinctColumnValuesProvider(String ... values) throws IOException {
            File tmpFile = File.createTempFile("MockDistinctColumnValuesProvider", ".txt");
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), StandardCharsets.UTF_8)));
            this.set = Sets.newTreeSet();
            for (String value : values) {
                out.println(value);
                this.set.add(value);
            }
            out.close();
            this.tmpFilePath = HadoopUtil.fixWindowsPath((String)("file://" + tmpFile.getAbsolutePath()));
            tmpFile.deleteOnExit();
        }

        public IReadableTable getDistinctValuesFor(TblColRef col) {
            return new DFSFileTable(this.tmpFilePath, -1);
        }
    }
}

