/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.property;

import com.google.common.base.Strings;
import java.util.Locale;

public enum QueryPropertyEnum {
    ID_CODE("QUERY_HASH_CODE"),
    TYPE("QUERY_TYPE"),
    USER("KUSER"),
    PROJECT("PROJECT"),
    REALIZATION("REALIZATION"),
    REALIZATION_TYPE("REALIZATION_TYPE"),
    EXCEPTION("EXCEPTION"),
    TIME_COST("QUERY_TIME_COST"),
    CALCITE_RETURN_COUNT("CALCITE_COUNT_RETURN"),
    STORAGE_RETURN_COUNT("STORAGE_COUNT_RETURN"),
    AGGR_FILTER_COUNT("CALCITE_COUNT_AGGREGATE_FILTER");

    private final String propertyName;

    private QueryPropertyEnum(String name) {
        this.propertyName = name;
    }

    public static QueryPropertyEnum getByName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        for (QueryPropertyEnum property : QueryPropertyEnum.values()) {
            if (!property.propertyName.equals(name.toUpperCase(Locale.ROOT))) continue;
            return property;
        }
        return null;
    }

    public String toString() {
        return this.propertyName;
    }
}

