/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metrics.lib.Record;

public class RecordEvent
implements Record,
Map<String, Object>,
Serializable {
    private static final InternalThreadLocal<ByteArrayOutputStream> _localBaos = new InternalThreadLocal();
    static String localHostname;
    private final Map<String, Object> backingMap;

    private RecordEvent(Map<String, Object> map) {
        this.backingMap = map;
    }

    public RecordEvent(String eventType) {
        this(eventType, localHostname);
    }

    public RecordEvent(String eventType, long time) {
        this(eventType, localHostname, time);
    }

    public RecordEvent(String eventType, String host) {
        this(eventType, host, System.currentTimeMillis());
    }

    public RecordEvent(String eventType, String host, long time) {
        this(null, eventType, host, time);
    }

    public RecordEvent(Map<String, Object> map, String eventType, String host, long time) {
        this.backingMap = map != null ? map : Maps.newHashMap();
        this.setEventType(eventType);
        this.setHost(host);
        this.setTime(time);
    }

    public String getEventType() {
        return (String)this.get(RecordReserveKeyEnum.TYPE.toString());
    }

    private void setEventType(String eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("EventType cannot be null.");
        }
        this.put(RecordReserveKeyEnum.TYPE.toString(), (Object)eventType);
    }

    public String getHost() {
        return (String)this.get(RecordReserveKeyEnum.HOST.toString());
    }

    private void setHost(String host) {
        this.put(RecordReserveKeyEnum.HOST.toString(), (Object)host);
    }

    @Override
    public Long getTime() {
        return (Long)this.get(RecordReserveKeyEnum.TIME.toString());
    }

    private void setTime(Long time) {
        if (time == null) {
            throw new IllegalArgumentException("Time cannot be null.");
        }
        this.put(RecordReserveKeyEnum.TIME.toString(), (Object)time);
    }

    public void resetTime() {
        this.setTime(System.currentTimeMillis());
    }

    public String getID() {
        return (String)this.get(RecordReserveKeyEnum.ID.toString());
    }

    public void setID(String id) {
        this.put(RecordReserveKeyEnum.ID.toString(), (Object)id);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) || this.backingMap.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.backingMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.backingMap.putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.backingMap.remove(key);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    public String toString() {
        return this.backingMap.toString();
    }

    @Override
    public Collection<Object> values() {
        return this.backingMap.values();
    }

    @Override
    public String getType() {
        return this.getEventType();
    }

    @Override
    public byte[] getKey() {
        return (this.getHost() + "-" + this.getTime() + "-" + this.getID()).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public Map<String, Object> getValueRaw() {
        HashMap cloneMap = Maps.newHashMap(this.backingMap);
        cloneMap.remove(RecordReserveKeyEnum.TYPE.toString());
        return cloneMap;
    }

    @Override
    public byte[] getValue() {
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)_localBaos.get();
            if (baos == null) {
                baos = new ByteArrayOutputStream();
                _localBaos.set((Object)baos);
            }
            baos.reset();
            JsonUtil.writeValue((OutputStream)baos, this.getValueRaw());
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RecordEvent clone() {
        HashMap cloneMap = Maps.newHashMap();
        cloneMap.putAll(this.backingMap);
        return new RecordEvent(cloneMap);
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            localHostname = addr.getHostName() + ":" + addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            localHostname = "Unknown";
        }
    }

    public static enum RecordReserveKeyEnum {
        TYPE("EVENT_TYPE"),
        ID("EVENT_ID"),
        HOST("HOST"),
        TIME("KTIMESTAMP");

        private final String reserveKey;

        private RecordReserveKeyEnum(String key) {
            this.reserveKey = key;
        }

        public String toString() {
            return this.reserveKey;
        }

        public RecordReserveKeyEnum getByKey(String key) {
            for (RecordReserveKeyEnum reserveKey : RecordReserveKeyEnum.values()) {
                if (!reserveKey.reserveKey.equals(key)) continue;
                return reserveKey;
            }
            return null;
        }
    }
}

