/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.AbstractActiveReservoir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantReservoir
extends AbstractActiveReservoir {
    private static final Logger logger = LoggerFactory.getLogger(InstantReservoir.class);

    @Override
    public void update(Record record) {
        if (!this.isReady) {
            logger.info("Current reservoir is not ready for update record");
            return;
        }
        this.onRecordUpdate(record);
    }

    @Override
    public int size() {
        return 0;
    }

    private void onRecordUpdate(Record record) {
        boolean ifSucceed = true;
        for (ActiveReservoirListener listener : this.listeners) {
            if (this.notifyListenerOfUpdatedRecord(listener, record)) continue;
            ifSucceed = false;
            logger.warn("It fails to notify listener " + listener.toString() + " of updated record " + Arrays.toString(record.getKey()));
        }
        if (!ifSucceed) {
            this.notifyListenerHAOfUpdatedRecord(record);
        }
    }

    private boolean notifyListenerOfUpdatedRecord(ActiveReservoirListener listener, Record record) {
        ArrayList recordsList = Lists.newArrayList();
        recordsList.add(record);
        return listener.onRecordUpdate(recordsList);
    }

    private boolean notifyListenerHAOfUpdatedRecord(Record record) {
        logger.info("The HA listener " + this.listenerHA.toString() + " for updated record " + Arrays.toString(record.getKey()) + " will be started");
        if (!this.notifyListenerOfUpdatedRecord(this.listenerHA, record)) {
            logger.error("The HA listener also fails!!!");
            return false;
        }
        return true;
    }
}

