/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.kylin.metrics.lib.ActiveReservoir;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.impl.StubReservoirReporter;

public abstract class AbstractActiveReservoir
implements ActiveReservoir {
    protected List<ActiveReservoirListener> listeners = Lists.newArrayList();
    protected ActiveReservoirListener listenerHA;
    protected boolean isReady;

    public AbstractActiveReservoir() {
        this.listenerHA = new StubReservoirReporter().listener;
        this.isReady = false;
    }

    @Override
    public void addListener(ActiveReservoirListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ActiveReservoirListener listener) {
        listener.close();
        this.listeners.remove(listener);
    }

    @Override
    public void removeAllListener() {
        for (ActiveReservoirListener listener : this.listeners) {
            listener.close();
        }
        this.listeners.clear();
    }

    @Override
    public void setHAListener(ActiveReservoirListener listener) {
        this.listenerHA = listener;
    }

    @Override
    public void start() {
        this.isReady = true;
    }

    @Override
    public void stop() {
        this.isReady = false;
    }

    @Override
    public void close() {
        this.stop();
        this.removeAllListener();
    }
}

