/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AbstractKylinTestCase;

public class LocalFileMetadataTestCase
extends AbstractKylinTestCase {
    @Override
    public void createTestMetadata() {
        LocalFileMetadataTestCase.createTestMetadata("../examples/test_case_data/localmeta");
    }

    public static void createTestMetadata(String testDataFolder) {
        KylinConfig.destoryInstance();
        String tempTestMetadataUrl = "../examples/test_metadata";
        try {
            FileUtils.deleteDirectory((File)new File(tempTestMetadataUrl));
            FileUtils.copyDirectory((File)new File(testDataFolder), (File)new File(tempTestMetadataUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (System.getProperty("KYLIN_CONF") == null && System.getenv("KYLIN_CONF") == null) {
            System.setProperty("KYLIN_CONF", tempTestMetadataUrl);
        }
        KylinConfig.getInstanceFromEnv().setMetadataUrl(tempTestMetadataUrl);
    }

    public static void cleanAfterClass() {
        String tempTestMetadataUrl = "../examples/test_metadata";
        try {
            FileUtils.deleteDirectory((File)new File(tempTestMetadataUrl));
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't delete directory " + tempTestMetadataUrl, e);
        }
        LocalFileMetadataTestCase.staticCleanupTestMetadata();
    }

    @Override
    public void cleanupTestMetadata() {
        LocalFileMetadataTestCase.cleanAfterClass();
    }

    protected ResourceStore getStore() {
        return ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    }
}

