/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.kylin.common.hll.HyperLogLogPlusCounter;
import org.apache.kylin.common.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class HyperLogLogCounterTest {
    ByteBuffer buf = ByteBuffer.allocate(0x100000);
    Random rand1 = new Random(1L);
    Random rand2 = new Random(2L);
    Random rand3 = new Random(3L);
    int errorCount1 = 0;
    int errorCount2 = 0;
    int errorCount3 = 0;

    private Set<String> generateTestData(int n) {
        HashSet<String> testData = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            String[] samples;
            for (String sample : samples = this.generateSampleData()) {
                testData.add(sample);
            }
        }
        return testData;
    }

    private String[] generateSampleData() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 19; ++i) {
            buf.append(Math.abs(this.rand1.nextInt()) % 10);
        }
        String header = buf.toString();
        int size = Math.abs(this.rand3.nextInt()) % 9 + 1;
        String[] samples = new String[size];
        for (int k = 0; k < size; ++k) {
            buf = new StringBuilder(header);
            buf.append("-");
            for (int i = 0; i < 10; ++i) {
                buf.append(Math.abs(this.rand3.nextInt()) % 10);
            }
            samples[k] = buf.toString();
        }
        return samples;
    }

    @Test
    public void countTest() throws IOException {
        int n = 10;
        for (int i = 0; i < 5; ++i) {
            this.count(n);
            n *= 10;
        }
    }

    private void count(int n) throws IOException {
        Set<String> testSet = this.generateTestData(n);
        HyperLogLogPlusCounter hllc = this.newHLLC();
        for (String testData : testSet) {
            hllc.add(Bytes.toBytes((String)testData));
        }
        long estimate = hllc.getCountEstimate();
        double errorRate = hllc.getErrorRate();
        double actualError = (double)Math.abs((long)testSet.size() - estimate) / (double)testSet.size();
        System.out.println(estimate);
        System.out.println(testSet.size());
        System.out.println(errorRate);
        System.out.println("=" + actualError);
        Assert.assertTrue((actualError < errorRate * 3.0 ? 1 : 0) != 0);
        this.checkSerialize(hllc);
    }

    private void checkSerialize(HyperLogLogPlusCounter hllc) throws IOException {
        long estimate = hllc.getCountEstimate();
        this.buf.clear();
        hllc.writeRegisters(this.buf);
        this.buf.flip();
        hllc.readRegisters(this.buf);
        Assert.assertEquals((long)estimate, (long)hllc.getCountEstimate());
    }

    @Test
    public void mergeTest() throws IOException {
        double error = 0.0;
        double absError = 0.0;
        int n = 100;
        for (int i = 0; i < n; ++i) {
            double e = this.merge();
            error += e;
            absError += Math.abs(e);
        }
        System.out.println("Total average error is " + error / (double)n + " and absolute error is " + absError / (double)n);
        System.out.println("  errorRateCount1 is " + this.errorCount1 + "!");
        System.out.println("  errorRateCount2 is " + this.errorCount2 + "!");
        System.out.println("  errorRateCount3 is " + this.errorCount3 + "!");
        Assert.assertTrue(((double)this.errorCount1 <= (double)n * 0.4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)this.errorCount2 <= (double)n * 0.08 ? 1 : 0) != 0);
        Assert.assertTrue(((double)this.errorCount3 <= (double)n * 0.02 ? 1 : 0) != 0);
    }

    private double merge() throws IOException {
        int ln = 50;
        int dn = 300;
        HashSet<String> testSet = new HashSet<String>();
        HyperLogLogPlusCounter[] hllcs = new HyperLogLogPlusCounter[ln];
        for (int i = 0; i < ln; ++i) {
            hllcs[i] = this.newHLLC();
            for (int k = 0; k < dn; ++k) {
                String[] samples;
                for (String data : samples = this.generateSampleData()) {
                    testSet.add(data);
                    hllcs[i].add(Bytes.toBytes((String)data));
                }
            }
        }
        HyperLogLogPlusCounter mergeHllc = this.newHLLC();
        for (HyperLogLogPlusCounter hllc : hllcs) {
            mergeHllc.merge(hllc);
            this.checkSerialize(mergeHllc);
        }
        double errorRate = mergeHllc.getErrorRate();
        long estimate = mergeHllc.getCountEstimate();
        double actualError = (double)((long)testSet.size() - estimate) / (double)testSet.size();
        System.out.println(testSet.size() + "-" + estimate + " ~ " + actualError);
        if (Math.abs(actualError) > errorRate) {
            ++this.errorCount1;
        }
        if (Math.abs(actualError) > 2.0 * errorRate) {
            ++this.errorCount2;
        }
        if (Math.abs(actualError) > 3.0 * errorRate) {
            ++this.errorCount3;
        }
        return actualError;
    }

    @Test
    public void testPerformance() throws IOException {
        int N = 3;
        int M = 1000;
        HyperLogLogPlusCounter[] samples = new HyperLogLogPlusCounter[N];
        for (int i = 0; i < N; ++i) {
            samples[i] = this.newHLLC();
            for (String str : this.generateTestData(10000)) {
                samples[i].add(str);
            }
        }
        System.out.println("Perf test running ... ");
        long start = System.currentTimeMillis();
        HyperLogLogPlusCounter sum = this.newHLLC();
        for (int i = 0; i < M; ++i) {
            sum.clear();
            for (int j = 0; j < N; ++j) {
                sum.merge(samples[j]);
                this.checkSerialize(sum);
            }
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Perf test result: " + duration / 1000L + " seconds");
    }

    @Test
    public void testEquivalence() {
        byte[] a = new byte[]{0, 3, 4, 42, 2, 2};
        byte[] b = new byte[]{3, 4, 42};
        HyperLogLogPlusCounter ha = new HyperLogLogPlusCounter();
        HyperLogLogPlusCounter hb = new HyperLogLogPlusCounter();
        ha.add(a, 1, 3);
        hb.add(b);
        Assert.assertTrue((ha.getCountEstimate() == hb.getCountEstimate() ? 1 : 0) != 0);
    }

    private HyperLogLogPlusCounter newHLLC() {
        return new HyperLogLogPlusCounter(16);
    }
}

