/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.HBaseConnection;

public class HbaseImporter {
    private static final Log logger = LogFactory.getLog(HbaseImporter.class);

    public static void importHBaseData(String hbaseTarLocation, Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        String[] tableNames;
        if (System.getenv("JAVA_HOME") == null) {
            logger.error((Object)"Didn't find $JAVA_HOME, this will cause HBase data import failed. Please set $JAVA_HOME.");
            logger.error((Object)"Skipping table import...");
            return;
        }
        File exportFile = new File(hbaseTarLocation);
        if (!exportFile.exists()) {
            logger.error((Object)("Didn't find the export achieve file on " + exportFile.getAbsolutePath()));
            return;
        }
        File folder = File.createTempFile("hbase-import", "tmp");
        if (folder.exists()) {
            FileUtils.forceDelete((File)folder);
        }
        folder.mkdirs();
        FileUtils.forceDeleteOnExit((File)folder);
        FileUtil.unTar((File)exportFile, (File)folder);
        String[] child = folder.list();
        Preconditions.checkState((child.length == 1 ? 1 : 0) != 0);
        String backupFolderName = child[0];
        File backupFolder = new File(folder, backupFolderName);
        for (String table : tableNames = backupFolder.list()) {
            if (!table.equalsIgnoreCase("kylin_metadata") && !table.startsWith("KYLIN_")) continue;
            if (table.startsWith("KYLIN_II")) {
                HBaseConnection.createHTableIfNeeded((String)KylinConfig.getInstanceFromEnv().getStorageUrl(), (String)table, (String[])new String[]{"f"});
            } else if (table.startsWith("KYLIN_")) {
                HBaseConnection.createHTableIfNeeded((String)KylinConfig.getInstanceFromEnv().getStorageUrl(), (String)table, (String[])new String[]{"F1", "F2"});
            }
            String importLocation = "file://" + backupFolder.getAbsolutePath() + "/" + table;
            String[] args = new String[]{table, importLocation};
            boolean result = HbaseImporter.runImport(args, conf);
            logger.info((Object)("importing table '" + table + "' with result:" + result));
            if (!result) break;
        }
    }

    private static boolean runImport(String[] args, Configuration configuration) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser opts = new GenericOptionsParser(new Configuration(configuration), args);
        Configuration newConf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        Job job = Import.createSubmittableJob((Configuration)newConf, (String[])args);
        job.waitForCompletion(false);
        return job.isSuccessful();
    }

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        if (args.length != 1) {
            logger.error((Object)"Usage: HbaseImporter hbase_tar_lcoation");
            System.exit(-1);
        }
        logger.info((Object)"The KylinConfig being used:");
        logger.info((Object)"=================================================");
        KylinConfig.getInstanceFromEnv().printProperties();
        logger.info((Object)"=================================================");
        HbaseImporter.importHBaseData(args[0], HBaseConfiguration.create());
    }
}

