/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HadoopUtilTest {
    @BeforeClass
    public static void beforeClass() {
        System.setProperty("KYLIN_CONF", "../examples/test_case_data/sandbox");
    }

    @After
    public void after() {
        HadoopUtil.setCurrentConfiguration(null);
        HadoopUtil.setCurrentHBaseConfiguration(null);
    }

    @Test
    public void testGetCurrentHBaseConfiguration() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setProperty("kylin.hbase.cluster.fs", "hdfs://hbase-cluster/");
        Configuration conf = HadoopUtil.getCurrentHBaseConfiguration();
        Assert.assertEquals((Object)"hdfs://hbase-cluster/", (Object)conf.get("fs.defaultFS"));
    }

    @Test
    public void testMakeQualifiedPathInHBaseCluster() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setProperty("kylin.hbase.cluster.fs", "file:/");
        String path = HadoopUtil.makeQualifiedPathInHBaseCluster((String)"/path/to/test/hbase");
        Assert.assertEquals((Object)"file:/path/to/test/hbase", (Object)path);
    }
}

