/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.HBaseResourceStore;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.HbaseImporter;

public class HBaseMiniclusterHelper {
    public static final String SHARED_STORAGE_PREFIX = "KYLIN_";
    public static final String CUBE_STORAGE_PREFIX = "KYLIN_";
    public static final String II_STORAGE_PREFIX = "KYLIN_II";
    public static final String TEST_METADATA_TABLE = "kylin_metadata";
    private static final String hbaseTarLocation = "../examples/test_case_data/minicluster/hbase-export.tar.gz";
    private static final String iiEndpointClassName = "org.apache.kylin.storage.hbase.coprocessor.endpoint.IIEndpoint";
    public static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static volatile boolean clusterStarted = false;
    private static String hbaseconnectionUrl = "";
    private static final Log logger = LogFactory.getLog(HBaseMiniclusterHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startupMinicluster() throws Exception {
        HBaseMetadataTestCase.staticCreateTestMetadata("../examples/test_case_data/minicluster");
        if (!clusterStarted) {
            Class<HBaseMiniclusterHelper> clazz = HBaseMiniclusterHelper.class;
            synchronized (HBaseMiniclusterHelper.class) {
                if (!clusterStarted) {
                    HBaseMiniclusterHelper.startupMiniClusterAndImportData();
                    clusterStarted = true;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        } else {
            HBaseMiniclusterHelper.updateKylinConfigWithMinicluster();
        }
    }

    private static void updateKylinConfigWithMinicluster() {
        KylinConfig.getInstanceFromEnv().setMetadataUrl("kylin_metadata@" + hbaseconnectionUrl);
        KylinConfig.getInstanceFromEnv().setStorageUrl(hbaseconnectionUrl);
    }

    private static void startupMiniClusterAndImportData() throws Exception {
        logger.info((Object)"Going to start mini cluster.");
        if (HBaseMiniclusterHelper.existInClassPath(iiEndpointClassName)) {
            UTIL.getConfiguration().setStrings("hbase.coprocessor.region.classes", new String[]{iiEndpointClassName});
        }
        UTIL.getConfiguration().setInt("hbase.master.info.port", -1);
        MiniHBaseCluster hbaseCluster = UTIL.startMiniCluster();
        Configuration config = hbaseCluster.getConf();
        String host = config.get("hbase.zookeeper.quorum");
        String port = config.get("hbase.zookeeper.property.clientPort");
        String parent = config.get("zookeeper.znode.parent");
        config.set("zookeeper.session.timeout", "1200000");
        config.set("hbase.zookeeper.property.tickTime", "6000");
        config.set(HConstants.HBASE_CLIENT_PAUSE, "3000");
        config.set(HConstants.HBASE_CLIENT_RETRIES_NUMBER, "1");
        config.set("hbase.client.operation.timeout", "60000");
        hbaseconnectionUrl = "hbase:" + host + ":" + port + ":" + parent;
        HBaseMiniclusterHelper.updateKylinConfigWithMinicluster();
        UTIL.startMiniMapReduceCluster();
        HBaseResourceStore store = new HBaseResourceStore(KylinConfig.getInstanceFromEnv());
        HbaseImporter.importHBaseData(hbaseTarLocation, UTIL.getConfiguration());
    }

    private static boolean existInClassPath(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }

    public static void shutdownMiniCluster() {
        logger.info((Object)"Going to shutdown mini cluster.");
        try {
            UTIL.shutdownMiniMapReduceCluster();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HBaseMiniclusterHelper t = new HBaseMiniclusterHelper();
        logger.info((Object)t);
        try {
            HBaseMiniclusterHelper.startupMinicluster();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            HBaseMiniclusterHelper.shutdownMiniCluster();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HBaseMiniclusterHelper.shutdownMiniCluster();
            }
        });
    }
}

