/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.kylin.common.util.BytesUtil;
import org.junit.Test;

public class BytesUtilTest
extends TestCase {
    @Test
    public void test() {
        ByteBuffer buffer = ByteBuffer.allocate(10000);
        int[] x = new int[]{1, 2, 3};
        BytesUtil.writeIntArray((int[])x, (ByteBuffer)buffer);
        buffer.flip();
        byte[] buf = new byte[buffer.limit()];
        System.arraycopy(buffer.array(), 0, buf, 0, buffer.limit());
        ByteBuffer newBuffer = ByteBuffer.wrap(buf);
        int[] y = BytesUtil.readIntArray((ByteBuffer)newBuffer);
        BytesUtilTest.assertEquals((int)y[2], (int)3);
    }

    @Test
    public void testBooleanArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10000);
        boolean[] x = new boolean[]{true, false, true};
        BytesUtil.writeBooleanArray((boolean[])x, (ByteBuffer)buffer);
        buffer.flip();
        boolean[] y = BytesUtil.readBooleanArray((ByteBuffer)buffer);
        BytesUtilTest.assertEquals((boolean)y[2], (boolean)true);
        BytesUtilTest.assertEquals((boolean)y[1], (boolean)false);
    }

    @Test
    public void testReadable() {
        String x = "\\x00\\x00\\x00\\x00\\x00\\x01\\xFC\\xA8";
        byte[] bytes = BytesUtil.fromReadableText((String)x);
        String y = BytesUtil.toHex((byte[])bytes);
        BytesUtilTest.assertEquals((String)x, (String)y);
    }
}

