/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.lang.reflect.Method;
import org.apache.kylin.common.KylinConfig;

public abstract class AbstractKylinTestCase {
    public static final String LOCALMETA_TEST_DATA = "../examples/test_case_data/localmeta";
    public static final String LOCALMETA_TEST_DATA_V1 = "../examples/test_case_data/localmeta_v1";
    public static final String MINICLUSTER_TEST_DATA = "../examples/test_case_data/minicluster";
    public static final String SANDBOX_TEST_DATA = "../examples/test_case_data/sandbox";
    public static final String[] SERVICES_WITH_CACHE = new String[]{"org.apache.kylin.metadata.MetadataManager", "org.apache.kylin.cube.CubeManager", "org.apache.kylin.cube.CubeDescManager", "org.apache.kylin.invertedindex.IIDescManager", "org.apache.kylin.invertedindex.IIManager", "org.apache.kylin.metadata.realization.RealizationRegistry", "org.apache.kylin.storage.hybrid.HybridManager", "org.apache.kylin.metadata.project.ProjectManager"};

    public abstract void createTestMetadata() throws Exception;

    public abstract void cleanupTestMetadata() throws Exception;

    public static KylinConfig getTestConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    public static void staticCreateTestMetadata(String kylinConfigFolder) {
        KylinConfig.destoryInstance();
        if (System.getProperty("KYLIN_CONF") == null && System.getenv("KYLIN_CONF") == null) {
            System.setProperty("KYLIN_CONF", kylinConfigFolder);
        }
    }

    public static void staticCleanupTestMetadata() {
        AbstractKylinTestCase.cleanupCache();
        System.clearProperty("KYLIN_CONF");
        KylinConfig.destoryInstance();
    }

    private static void cleanupCache() {
        for (String serviceClass : SERVICES_WITH_CACHE) {
            try {
                Class<?> cls = Class.forName(serviceClass);
                Method method = cls.getDeclaredMethod("clearCache", new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                System.err.println("Error clean up cache " + serviceClass);
                e.printStackTrace();
            }
        }
    }
}

