/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.HBaseResourceStore;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.HBaseMetadataTestCase;
import org.apache.kylin.common.util.HadoopUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HBaseResourceStoreTest
extends HBaseMetadataTestCase {
    @Before
    public void setup() throws Exception {
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testHBaseStore() throws Exception {
        this.testAStore(ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBaseStoreWithLargeCell() throws Exception {
        String path = "/cube/_test_large_cell.json";
        String largeContent = "THIS_IS_A_LARGE_CELL";
        StringEntity content = new StringEntity(largeContent);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int origSize = config.getHBaseKeyValueSize();
        ResourceStore store = ResourceStore.getStore((KylinConfig)KylinConfig.getInstanceFromEnv());
        try {
            config.setProperty("kylin.hbase.client.keyvalue.maxsize", String.valueOf(largeContent.length() - 1));
            store.deleteResource(path);
            store.putResource(path, (RootPersistentEntity)content, StringEntity.serializer);
            Assert.assertTrue((boolean)store.exists(path));
            StringEntity t = (StringEntity)store.getResource(path, StringEntity.class, StringEntity.serializer);
            Assert.assertEquals((Object)((Object)content), (Object)((Object)t));
            Path redirectPath = ((HBaseResourceStore)store).bigCellHDFSPath(path);
            Configuration hconf = HadoopUtil.getCurrentHBaseConfiguration();
            FileSystem fileSystem = FileSystem.get((Configuration)hconf);
            Assert.assertTrue((boolean)fileSystem.exists(redirectPath));
            FSDataInputStream in = fileSystem.open(redirectPath);
            Assert.assertEquals((Object)largeContent, (Object)in.readUTF());
            in.close();
            store.deleteResource(path);
        }
        finally {
            config.setProperty("kylin.hbase.client.keyvalue.maxsize", "" + origSize);
            store.deleteResource(path);
        }
    }

    void testAStore(ResourceStore store) throws IOException {
        String dir1 = "/cube";
        String path1 = "/cube/_test.json";
        StringEntity content1 = new StringEntity("anything");
        String dir2 = "/table";
        String path2 = "/table/_test.json";
        StringEntity content2 = new StringEntity("something");
        store.deleteResource(path1);
        store.deleteResource(path2);
        store.putResource(path1, (RootPersistentEntity)content1, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path1));
        StringEntity t = (StringEntity)store.getResource(path1, StringEntity.class, StringEntity.serializer);
        Assert.assertEquals((Object)((Object)content1), (Object)((Object)t));
        store.putResource(path2, (RootPersistentEntity)content2, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path2));
        t = (StringEntity)store.getResource(path2, StringEntity.class, StringEntity.serializer);
        Assert.assertEquals((Object)((Object)content2), (Object)((Object)t));
        t.str = "new string";
        store.putResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
        try {
            t.setLastModified(t.lastModified - 1L);
            store.putResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
            Assert.fail((String)"write conflict should trigger IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        ArrayList list = store.listResources(dir1);
        Assert.assertTrue((boolean)list.contains(path1));
        Assert.assertTrue((!list.contains(path2) ? 1 : 0) != 0);
        list = store.listResources(dir2);
        Assert.assertTrue((boolean)list.contains(path2));
        Assert.assertTrue((!list.contains(path1) ? 1 : 0) != 0);
        list = store.listResources("/");
        Assert.assertTrue((boolean)list.contains(dir1));
        Assert.assertTrue((boolean)list.contains(dir2));
        Assert.assertTrue((!list.contains(path1) ? 1 : 0) != 0);
        Assert.assertTrue((!list.contains(path2) ? 1 : 0) != 0);
        list = store.listResources(path1);
        Assert.assertNull((Object)list);
        list = store.listResources(path2);
        Assert.assertNull((Object)list);
        store.deleteResource(path1);
        Assert.assertTrue((!store.exists(path1) ? 1 : 0) != 0);
        list = store.listResources(dir1);
        Assert.assertTrue((list == null || !list.contains(path1) ? 1 : 0) != 0);
        store.deleteResource(path2);
        Assert.assertTrue((!store.exists(path2) ? 1 : 0) != 0);
        list = store.listResources(dir2);
        Assert.assertTrue((list == null || !list.contains(path2) ? 1 : 0) != 0);
    }

    public static class StringEntity
    extends RootPersistentEntity {
        static final Serializer<StringEntity> serializer = new Serializer<StringEntity>(){

            public void serialize(StringEntity obj, DataOutputStream out) throws IOException {
                out.writeUTF(obj.str);
            }

            public StringEntity deserialize(DataInputStream in) throws IOException {
                String str = in.readUTF();
                return new StringEntity(str);
            }
        };
        String str;

        public StringEntity(String str) {
            this.str = str;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof StringEntity)) {
                return false;
            }
            return StringUtils.equals((String)this.str, (String)((StringEntity)((Object)obj)).str);
        }

        public String toString() {
            return this.str;
        }
    }
}

