/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.gateway.shell.hdfs;

import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.BasicResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;

import java.io.IOException;
import java.util.concurrent.Callable;

public class Status {

  public static class Request extends AbstractRequest<Response> {

    private String file;

    Request(Hadoop session) {
      super(session);
    }

    public Request file(String file) {
      this.file = file;
      return this;
    }

    public Callable<Response> callable() {
      return new Callable<Response>() {
        @Override
        public Response call() throws Exception {
          URIBuilder uri = uri(Hdfs.SERVICE_PATH, file);
          addQueryParam(uri, "op", "GETFILESTATUS");
          HttpGet get = new HttpGet(uri.build());
          return new Response(execute(get));
        }
      };
    }
  }

  public static class Response extends BasicResponse {

    Response(HttpResponse response) throws IOException {
      super(response);
    }

    public boolean exists() {
      return getStatusCode() == 200;
    }
  }
}
