/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.hdfs.dispatch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.gateway.config.Configure;
import org.apache.hadoop.gateway.ha.provider.HaProvider;
import org.apache.hadoop.gateway.ha.provider.HaServiceConfig;
import org.apache.hadoop.gateway.hdfs.dispatch.HdfsHttpClientDispatch;
import org.apache.hadoop.gateway.hdfs.dispatch.SafeModeException;
import org.apache.hadoop.gateway.hdfs.dispatch.StandbyException;
import org.apache.hadoop.gateway.hdfs.i18n.WebHdfsMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;

public class WebHdfsHaDispatch
extends HdfsHttpClientDispatch {
    private static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    private static final String RETRY_COUNTER_ATTRIBUTE = "dispatch.ha.retry.counter";
    public static final String RESOURCE_ROLE = "WEBHDFS";
    private static final WebHdfsMessages LOG = (WebHdfsMessages)MessagesFactory.get(WebHdfsMessages.class);
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private int maxRetryAttempts = 3;
    private int retrySleep = 1000;
    private HaProvider haProvider;

    public void init() {
        super.init();
        if (this.haProvider != null) {
            HaServiceConfig serviceConfig = this.haProvider.getHaDescriptor().getServiceConfig(RESOURCE_ROLE);
            this.maxFailoverAttempts = serviceConfig.getMaxFailoverAttempts();
            this.failoverSleep = serviceConfig.getFailoverSleep();
            this.maxRetryAttempts = serviceConfig.getMaxRetryAttempts();
            this.retrySleep = serviceConfig.getRetrySleep();
        }
    }

    public HaProvider getHaProvider() {
        return this.haProvider;
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (StandbyException e) {
            LOG.errorReceivedFromStandbyNode(e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
        catch (SafeModeException e) {
            LOG.errorReceivedFromSafeModeNode(e);
            this.retryRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        if (inboundResponse.getStatusLine().getStatusCode() == 403) {
            BufferedHttpEntity entity = new BufferedHttpEntity(inboundResponse.getEntity());
            inboundResponse.setEntity((HttpEntity)entity);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            inboundResponse.getEntity().writeTo((OutputStream)outputStream);
            String body = new String(outputStream.toByteArray());
            if (body.contains("StandbyException")) {
                throw new StandbyException();
            }
            if (body.contains("SafeModeException") || body.contains("RetriableException")) {
                throw new SafeModeException();
            }
        }
        super.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
    }

    private void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.failingOverRequest(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            this.haProvider.markFailedURL(RESOURCE_ROLE, outboundRequest.getURI().toString());
            inboundRequest.setAttribute("targetRequestUrl", null);
            URI uri = this.getDispatchUrl(inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(RESOURCE_ROLE, e);
                }
            }
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, RESOURCE_ROLE);
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }

    private void retryRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        LOG.retryingRequest(outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(RETRY_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(RETRY_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxRetryAttempts) {
            if (this.retrySleep > 0) {
                try {
                    Thread.sleep(this.retrySleep);
                }
                catch (InterruptedException e) {
                    LOG.retrySleepFailed(RESOURCE_ROLE, e);
                }
            }
            this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        } else {
            LOG.maxRetryAttemptsReached(this.maxRetryAttempts, RESOURCE_ROLE, outboundRequest.getURI().toString());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }
}

