/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.hadoop.gateway.filter.AbstractGatewayFilter;

public class ResponseCookieFilter
extends AbstractGatewayFilter {
    private static final List<String> restrictedCookieValues = new ArrayList<String>(Arrays.asList("rememberMe"));

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
    }

    private class ResponseWrapper
    extends HttpServletResponseWrapper {
        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void addCookie(Cookie cookie) {
            if (cookie != null && this.isAllowedHeaderValue(cookie.getValue())) {
                super.addCookie(cookie);
            }
        }

        public void setHeader(String name, String value) {
            if (this.isAllowedHeaderValue(value)) {
                super.setHeader(name, value);
            }
        }

        public void addHeader(String name, String value) {
            if (this.isAllowedHeaderValue(value)) {
                super.addHeader(name, value);
            }
        }

        private boolean isAllowedHeaderValue(String value) {
            if (value != null) {
                for (String v : restrictedCookieValues) {
                    if (!value.contains(v)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

