/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.securequery;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.securequery.SecureQueryEncryptDescriptor;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.security.CryptoService;
import org.apache.hadoop.gateway.services.security.EncryptionResult;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class SecureQueryEncryptProcessor
implements UrlRewriteStepProcessor<SecureQueryEncryptDescriptor> {
    private static final String ENCRYPTED_PARAMETER_NAME = "_";
    private String clusterName;
    private CryptoService cryptoService = null;

    public String getType() {
        return "encrypt-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryEncryptDescriptor descriptor) throws Exception {
        this.clusterName = (String)environment.getAttribute("org.apache.hadoop.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.hadoop.gateway.gateway.services");
        this.cryptoService = (CryptoService)services.getService("CryptoService");
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        String str;
        Template url = context.getCurrentUrl();
        String path = str = url.toString();
        String query = null;
        int index = str.indexOf(63);
        if (index >= 0) {
            path = str.substring(0, index);
            if (index < str.length()) {
                query = str.substring(index + 1);
            }
        }
        if (query != null) {
            query = this.encode(query);
            url = Parser.parseLiteral((String)(path + "?" + ENCRYPTED_PARAMETER_NAME + "=" + query));
            context.setCurrentUrl(url);
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    public void destroy() {
    }

    private String encode(String string) throws UnsupportedEncodingException {
        EncryptionResult result = this.cryptoService.encryptForCluster(this.clusterName, "encryptQueryString", string.getBytes("UTF-8"));
        string = Base64.encodeBase64URLSafeString((byte[])result.toByteAray());
        return string;
    }
}

