/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.securequery;

import java.util.List;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ProviderDeploymentContributor;
import org.apache.hadoop.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.securequery.SecureQueryMessages;
import org.apache.hadoop.gateway.services.security.AliasService;
import org.apache.hadoop.gateway.services.security.AliasServiceException;
import org.apache.hadoop.gateway.topology.Provider;
import org.apache.hadoop.gateway.topology.Service;

public class SecureQueryDeploymentContributor
extends ProviderDeploymentContributorBase
implements ProviderDeploymentContributor {
    private static SecureQueryMessages log = (SecureQueryMessages)MessagesFactory.get(SecureQueryMessages.class);
    public static final String PROVIDER_ROLE_NAME = "secure-query";
    public static final String PROVIDER_IMPL_NAME = "default";
    private AliasService as;

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
        String clusterName = context.getTopology().getName();
        try {
            this.as.getPasswordFromAliasForCluster(clusterName, "encryptQueryString", true);
        }
        catch (AliasServiceException e) {
            log.unableCreatePasswordForEncryption((Exception)((Object)e));
        }
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        if (provider.isEnabled()) {
            // empty if block
        }
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }
}

