/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.securequery;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.securequery.SecureQueryDecryptDescriptor;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.security.CryptoService;
import org.apache.hadoop.gateway.services.security.EncryptionResult;
import org.apache.hadoop.gateway.util.urltemplate.Builder;
import org.apache.hadoop.gateway.util.urltemplate.Query;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class SecureQueryDecryptProcessor
implements UrlRewriteStepProcessor<SecureQueryDecryptDescriptor> {
    private static final String ENCRYPTED_PARAMETER_NAME = "_";
    private String clusterName;
    private CryptoService cryptoService;

    public String getType() {
        return "decrypt-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryDecryptDescriptor descriptor) throws Exception {
        this.clusterName = (String)environment.getAttribute("org.apache.hadoop.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.hadoop.gateway.gateway.services");
        this.cryptoService = (CryptoService)services.getService("CryptoService");
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        Template currUrl = context.getCurrentUrl();
        Builder newUrl = new Builder(currUrl);
        Map map = newUrl.getQuery();
        Query query = (Query)map.remove(ENCRYPTED_PARAMETER_NAME);
        if (query != null) {
            String value = query.getFirstValue().getPattern();
            value = this.decode(value);
            StringTokenizer outerParser = new StringTokenizer(value, "&");
            while (outerParser.hasMoreTokens()) {
                String pair = outerParser.nextToken();
                StringTokenizer innerParser = new StringTokenizer(pair, "=");
                if (!innerParser.hasMoreTokens()) continue;
                String paramName = innerParser.nextToken();
                if (innerParser.hasMoreTokens()) {
                    String paramValue = innerParser.nextToken();
                    map.remove(paramName);
                    newUrl.addQuery(paramName, "", paramValue, true);
                    continue;
                }
                newUrl.addQuery(paramName, "", null, true);
            }
            context.setCurrentUrl(newUrl.build());
            context.getParameters().resolve("gateway.name");
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    public void destroy() {
    }

    private String decode(String string) throws UnsupportedEncodingException {
        byte[] bytes = Base64.decodeBase64((String)string);
        EncryptionResult result = EncryptionResult.fromByteArray((byte[])bytes);
        byte[] clear = this.cryptoService.decryptForCluster(this.clusterName, "encryptQueryString", result.cipher, result.iv, result.salt);
        if (clear != null) {
            return new String(clear);
        }
        return null;
    }
}

