/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.securequery;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.securequery.SecureQueryDecodeDescriptor;
import org.apache.hadoop.gateway.util.urltemplate.Builder;
import org.apache.hadoop.gateway.util.urltemplate.Query;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class SecureQueryDecodeProcessor
implements UrlRewriteStepProcessor<SecureQueryDecodeDescriptor> {
    private static final String ENCODED_PARAMETER_NAME = "_";

    public String getType() {
        return "decode-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryDecodeDescriptor descriptor) throws Exception {
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        Template currUrl = context.getCurrentUrl();
        Builder newUrl = new Builder(currUrl);
        Map map = newUrl.getQuery();
        Query query = (Query)map.remove(ENCODED_PARAMETER_NAME);
        if (query != null) {
            String value = query.getFirstValue().getPattern();
            value = SecureQueryDecodeProcessor.decode(value);
            StringTokenizer outerParser = new StringTokenizer(value, "&");
            while (outerParser.hasMoreTokens()) {
                String pair = outerParser.nextToken();
                StringTokenizer innerParser = new StringTokenizer(pair, "=");
                if (!innerParser.hasMoreTokens()) continue;
                String paramName = innerParser.nextToken();
                if (innerParser.hasMoreTokens()) {
                    String paramValue = innerParser.nextToken();
                    map.remove(paramName);
                    newUrl.addQuery(paramName, "", paramValue, true);
                    continue;
                }
                newUrl.addQuery(paramName, "", null, true);
            }
            context.setCurrentUrl(newUrl.build());
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    public void destroy() {
    }

    private static String decode(String string) throws UnsupportedEncodingException {
        return new String(Base64.decodeBase64((String)string), "UTF-8");
    }
}

