/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.identityasserter.regex.filter;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexTemplate {
    private static Pattern directPattern = Pattern.compile("\\{(\\[?\\d+?\\]?)\\}");
    private static Pattern indirectPattern = Pattern.compile("\\[(\\d+?)\\]");
    Pattern inputPattern;
    String outputTemplate;
    Map<String, String> lookupTable;

    public RegexTemplate(String regex, String template) {
        this(regex, template, null);
    }

    public RegexTemplate(String regex, String template, Map<String, String> map) {
        this.inputPattern = Pattern.compile(regex);
        this.outputTemplate = template;
        this.lookupTable = map;
    }

    public String apply(String input) {
        String output = this.outputTemplate;
        Matcher inputMatcher = this.inputPattern.matcher(input);
        if (inputMatcher.find()) {
            output = this.expandTemplate(inputMatcher, output);
        }
        return output;
    }

    private String expandTemplate(Matcher inputMatcher, String output) {
        Matcher directMatcher = directPattern.matcher(output);
        while (directMatcher.find()) {
            int lookupIndex;
            String lookupValue = null;
            String lookupStr = directMatcher.group(1);
            Matcher indirectMatcher = indirectPattern.matcher(lookupStr);
            if (indirectMatcher.find()) {
                lookupStr = indirectMatcher.group(1);
                lookupIndex = Integer.parseInt(lookupStr);
                if (this.lookupTable != null) {
                    String lookupKey = inputMatcher.group(lookupIndex);
                    lookupValue = this.lookupTable.get(lookupKey);
                }
            } else {
                lookupIndex = Integer.parseInt(lookupStr);
                lookupValue = inputMatcher.group(lookupIndex);
            }
            output = directMatcher.replaceFirst(lookupValue == null ? "" : lookupValue);
            directMatcher = directPattern.matcher(output);
        }
        return output;
    }
}

