/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.identityasserter.regex.filter;

import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.gateway.identityasserter.common.filter.CommonIdentityAssertionFilter;
import org.apache.hadoop.gateway.identityasserter.regex.filter.RegexTemplate;
import org.apache.hadoop.gateway.security.principal.PrincipalMappingException;

public class RegexIdentityAssertionFilter
extends CommonIdentityAssertionFilter {
    private String input = null;
    private String output = null;
    private Map<String, String> dict;
    RegexTemplate template;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.input = filterConfig.getInitParameter("input");
            if (this.input == null) {
                this.input = "";
            }
            this.output = filterConfig.getInitParameter("output");
            if (this.output == null) {
                this.output = "";
            }
            this.dict = this.loadDictionary(filterConfig.getInitParameter("lookup"));
            this.template = new RegexTemplate(this.input, this.output, this.dict);
        }
        catch (PrincipalMappingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String[] mapGroupPrincipals(String mappedPrincipalName, Subject subject) {
        return null;
    }

    public String mapUserPrincipal(String principalName) {
        return this.template.apply(principalName);
    }

    private Map<String, String> loadDictionary(String config) throws PrincipalMappingException {
        TreeMap<String, String> dict = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        if (config != null && !config.isEmpty()) {
            try {
                StringTokenizer t = new StringTokenizer(config, ";");
                while (t.hasMoreTokens()) {
                    String nvp = t.nextToken();
                    String[] a = nvp.split("=");
                    dict.put(a[0].trim(), a[1].trim());
                }
                return dict;
            }
            catch (Exception e) {
                dict.clear();
                throw new PrincipalMappingException("Unable to load lookup dictionary from provided configuration: " + config + ".  No principal mapping will be provided.", e);
            }
        }
        return dict;
    }
}

