/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.i18n.messages.loggers.sl4j;

import org.apache.hadoop.gateway.i18n.messages.MessageLevel;
import org.apache.hadoop.gateway.i18n.messages.MessageLogger;
import org.slf4j.Logger;

public class Sl4jMessageLogger
implements MessageLogger {
    private Logger logger;

    Sl4jMessageLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isLoggable(MessageLevel level) {
        switch (level) {
            case FATAL: {
                return this.logger.isErrorEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
            case WARN: {
                return this.logger.isWarnEnabled();
            }
            case INFO: {
                return this.logger.isInfoEnabled();
            }
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
            case TRACE: {
                return this.logger.isTraceEnabled();
            }
        }
        return false;
    }

    public void log(StackTraceElement caller, MessageLevel messageLevel, String messageId, String messageText, Throwable thrown) {
        switch (messageLevel) {
            case FATAL: 
            case ERROR: {
                if (thrown == null) {
                    this.logger.error(messageText);
                    break;
                }
                this.logger.error(messageText, thrown);
                break;
            }
            case WARN: {
                if (thrown == null) {
                    this.logger.warn(messageText);
                    break;
                }
                this.logger.warn(messageText, thrown);
                break;
            }
            case INFO: {
                if (thrown == null) {
                    this.logger.info(messageText);
                    break;
                }
                this.logger.info(messageText, thrown);
                break;
            }
            case DEBUG: {
                if (thrown == null) {
                    this.logger.debug(messageText);
                    break;
                }
                this.logger.debug(messageText, thrown);
                break;
            }
            case TRACE: {
                if (thrown == null) {
                    this.logger.trace(messageText);
                    break;
                }
                this.logger.trace(messageText, thrown);
            }
        }
    }
}

