/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.system.commands;

import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.system.commands.AbstractSystemAction;

@Command(scope="system", name="property", description="Get or set a system property.")
public class SystemProperty
extends AbstractSystemAction {
    @Option(name="-p", aliases={"--persistent"}, description="Persist the new value to the etc/system.properties file")
    boolean persistent;
    @Argument(index=0, name="key", description="The system property name")
    String key;
    @Argument(index=1, name="value", required=false, description="New value for the system property")
    String value;

    protected Object doExecute() throws Exception {
        if (this.value != null) {
            return this.systemService.setSystemProperty(this.key, this.value, this.persistent);
        }
        return System.getProperty(this.key);
    }
}

