/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.action.ListAction;
import org.apache.karaf.shell.console.AbstractAction;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrActionSupport
extends AbstractAction {
    protected final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    private ScrService scrService;

    protected Object doExecute() throws Exception {
        if (this.scrService == null) {
            String msg = "ScrService is unavailable";
            System.out.println(msg);
            this.logger.warn(msg);
        } else {
            this.doScrAction(this.scrService);
        }
        return null;
    }

    protected abstract Object doScrAction(ScrService var1) throws Exception;

    public String getBoldString(String value) {
        return Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(value).a(Ansi.Attribute.INTENSITY_BOLD_OFF).toString();
    }

    public String buildRightPadBracketDisplay(String s, int max) {
        return String.format("%1$-" + max + "s", s);
    }

    public String buildLeftPadBracketDisplay(String s, int max) {
        return String.format("%1$-" + max + "s", s);
    }

    public BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(ListAction.class).getBundleContext();
    }

    public ScrService getScrService() {
        return this.scrService;
    }

    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }
}

