/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scr.command.action;

import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.scr.command.ScrUtils;
import org.apache.karaf.scr.command.action.ScrActionSupport;
import org.apache.karaf.shell.commands.Command;

@Command(scope="scr", name="list", description="Displays a list of available components")
public class ListAction
extends ScrActionSupport {
    @Override
    protected Object doScrAction(ScrService scrService) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing the List Action");
        }
        System.out.println(this.getBoldString("   ID   State             Component Name"));
        Component[] components = scrService.getComponents();
        for (Component component : ScrUtils.emptyIfNull(Component.class, components)) {
            String name = component.getName();
            String id = this.buildLeftPadBracketDisplay(component.getId() + "", 4);
            String state = this.buildRightPadBracketDisplay(ScrUtils.getState(component.getState()), 16);
            System.out.println("[" + id + "] [" + state + "] " + name);
        }
        return null;
    }
}

